/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.loader.universalbinary;

import com.atlassian.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class StaticResourceServlet
extends HttpServlet {
    private final Plugin plugin;
    private final String resourceBase;

    public StaticResourceServlet(Plugin plugin, String resourceBase) {
        this.plugin = plugin;
        this.resourceBase = resourceBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        URL url = this.findResourceUrl(path);
        if (url == null) {
            this.send404(res);
            return;
        }
        res.setHeader("Vary", "Accept-Encoding");
        res.setContentType(this.getServletContext().getMimeType(path));
        res.setHeader("Connection", "keep-alive");
        InputStream in = null;
        try {
            byte[] localData = IOUtils.toByteArray((InputStream)url.openStream());
            res.setContentLength(localData.length);
            ServletOutputStream sos = res.getOutputStream();
            sos.write(localData);
            sos.close();
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private URL findResourceUrl(String path) {
        return this.plugin.getResource(this.resourceBase + path);
    }

    private void send404(HttpServletResponse res) throws IOException {
        res.sendError(404, "Cannot find resource");
    }

    public void destroy() {
    }
}

