/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.host.common.util.RemotablePluginManifestReader;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.settings.SettingsManager;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.PermissionModuleDescriptor;
import com.atlassian.plugin.remotable.spi.permission.PermissionsReader;
import com.atlassian.plugin.remotable.spi.permission.scope.AbstractApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PermissionManagerImpl
implements PermissionManager {
    private final UserManager userManager;
    private final SettingsManager settingsManager;
    private final PluginAccessor pluginAccessor;
    private final PermissionsReader permissionsReader;
    private final BundleContext bundleContext;
    private final PluginModuleTracker<Permission, PermissionModuleDescriptor> permissionTracker;
    private final Set<ApiScope> DEFAULT_API_SCOPES = ImmutableSet.of((Object)new MacroCacheApiScope());

    @Autowired
    public PermissionManagerImpl(UserManager userManager, SettingsManager settingsManager, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, PermissionsReader permissionsReader, BundleContext bundleContext) {
        this(userManager, settingsManager, pluginAccessor, permissionsReader, bundleContext, (PluginModuleTracker<Permission, PermissionModuleDescriptor>)new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, PermissionModuleDescriptor.class));
    }

    PermissionManagerImpl(UserManager userManager, SettingsManager settingsManager, PluginAccessor pluginAccessor, PermissionsReader permissionsReader, BundleContext bundleContext, PluginModuleTracker<Permission, PermissionModuleDescriptor> pluginModuleTracker) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.settingsManager = (SettingsManager)Preconditions.checkNotNull((Object)settingsManager);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
        this.permissionsReader = (PermissionsReader)Preconditions.checkNotNull((Object)permissionsReader);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.permissionTracker = (PluginModuleTracker)Preconditions.checkNotNull(pluginModuleTracker);
    }

    @Override
    public Set<Permission> getPermissions(final InstallationMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)this.permissionTracker.getModules(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission p) {
                return p.getInstallationModes().contains((Object)mode);
            }
        }));
    }

    @Override
    public Set<String> getPermissionKeys(InstallationMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getPermissions(mode), (Function)new Function<Permission, String>(){

            public String apply(Permission p) {
                return p.getKey();
            }
        }));
    }

    @Override
    public boolean isRequestInApiScope(HttpServletRequest req, String pluginKey, String user) {
        return Iterables.any(this.getApiScopesForPlugin(pluginKey), (Predicate)new IsInApiScopePredicate(req, user));
    }

    private Iterable<ApiScope> getApiScopesForPlugin(String pluginKey) {
        return Iterables.concat(this.DEFAULT_API_SCOPES, this.getApiScopesForPermissions(this.getPermissionsForPlugin(pluginKey)));
    }

    private Iterable<ApiScope> getApiScopesForPermissions(Set<String> permissions) {
        return this.castToApiScopes(this.getApiScopesForPermissionsAsPermissions(permissions));
    }

    private Iterable<ApiScope> castToApiScopes(Iterable<Permission> permissions) {
        return Iterables.transform(permissions, (Function)new CastPermissionApiScope());
    }

    private Iterable<Permission> getApiScopesForPermissionsAsPermissions(Set<String> permissions) {
        return Iterables.filter((Iterable)this.permissionTracker.getModules(), (Predicate)Predicates.and((Predicate)new IsApiScope(), (Predicate)new IsInPermissions(permissions)));
    }

    private Set<String> getPermissionsForPlugin(String clientKey) {
        return (Set)Option.option((Object)this.pluginAccessor.getPlugin(clientKey)).fold(Suppliers.ofInstance((Object)ImmutableSet.of()), (Function)new Function<Plugin, Set<String>>(){

            public Set<String> apply(Plugin plugin) {
                return PermissionManagerImpl.this.permissionsReader.getPermissionsForPlugin(plugin);
            }
        });
    }

    @Override
    public boolean canInstallRemotePluginsFromMarketplace(String username) {
        return username != null && (this.isDogfoodUser(username) || this.userManager.isAdmin(username));
    }

    private boolean inDogfoodingGroup(String username) {
        return this.userManager.isUserInGroup(username, "developers") || this.userManager.isUserInGroup(username, "atlassian-staff") || this.userManager.isUserInGroup(username, "test-users");
    }

    @Override
    public void requirePermission(String pluginKey, String permissionKey) throws PermissionDeniedException {
        if (!this.getPermissionsForPlugin(pluginKey).contains(permissionKey)) {
            throw new PermissionDeniedException(pluginKey, String.format("Plugin '%s' requires a resource protected by '%s', but it did not request it.", pluginKey, permissionKey));
        }
    }

    @Override
    public boolean hasPermission(String pluginKey, String permissionKey) throws PermissionDeniedException {
        return this.getPermissionsForPlugin(pluginKey).contains(permissionKey);
    }

    @Override
    public boolean canModifyRemotePlugin(String username, String pluginKey) {
        return this.userManager.isAdmin(username) || this.isDogfoodUser(username) && username.equals(RemotablePluginManifestReader.getInstallerUser(BundleUtil.findBundleForPlugin(this.bundleContext, pluginKey)));
    }

    private boolean isDogfoodUser(String username) {
        return this.settingsManager.isAllowDogfooding() && this.inDogfoodingGroup(username);
    }

    @Override
    public boolean canRequestDeclaredPermissions(String username, Document descriptor, InstallationMode installationMode) {
        if (this.userManager.isSystemAdmin(username)) {
            return true;
        }
        Set<String> requestedPermissions = this.permissionsReader.readPermissionsFromDescriptor(descriptor, installationMode);
        return this.getPermissionKeys(installationMode).containsAll(requestedPermissions);
    }

    @Override
    public boolean canInstallArbitraryRemotePlugins(String userName) {
        return this.userManager.isSystemAdmin(userName) || this.isDogfoodUser(userName);
    }

    private static final class MacroCacheApiScope
    extends AbstractApiScope {
        public MacroCacheApiScope() {
            super("clear_macro_cache", (Set<InstallationMode>)ImmutableSet.of((Object)((Object)InstallationMode.LOCAL), (Object)((Object)InstallationMode.REMOTE)), new RestApiScopeHelper(Arrays.asList(new RestApiScopeHelper.RestScope("remotable-plugins", Arrays.asList("latest", "1"), "/macro", Arrays.asList("DELETE")))));
        }
    }

    private static final class CastPermissionApiScope
    implements Function<Permission, ApiScope> {
        private CastPermissionApiScope() {
        }

        public ApiScope apply(Permission permission) {
            return (ApiScope)permission;
        }
    }

    private static final class IsInPermissions
    implements Predicate<Permission> {
        private final Set<String> permissions;

        public IsInPermissions(Set<String> permissions) {
            this.permissions = (Set)Preconditions.checkNotNull(permissions);
        }

        public boolean apply(@Nullable Permission permission) {
            return permission != null && this.permissions.contains(permission.getKey());
        }
    }

    private static final class IsApiScope
    implements Predicate<Permission> {
        private IsApiScope() {
        }

        public boolean apply(@Nullable Permission permission) {
            return permission instanceof ApiScope;
        }
    }

    private static final class IsInApiScopePredicate
    implements Predicate<ApiScope> {
        private final HttpServletRequest request;
        private final String user;

        public IsInApiScopePredicate(HttpServletRequest request, @Nullable String user) {
            this.request = (HttpServletRequest)Preconditions.checkNotNull((Object)request);
            this.user = user;
        }

        public boolean apply(ApiScope scope) {
            return scope.allow(this.request, this.user);
        }
    }
}

