/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http;

import com.atlassian.util.concurrent.Promise;
import com.atlassian.xmlrpc.ServiceBean;
import com.atlassian.xmlrpc.ServiceBeanField;
import com.atlassian.xmlrpc.ServiceMethod;
import com.atlassian.xmlrpc.ServiceObject;
import com.atlassian.xmlrpc.XmlRpcClientProvider;
import com.google.common.base.Function;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public final class PromiseAwareXmlRpcInvocationHandler
implements InvocationHandler {
    private XmlRpcClientProvider clientProvider;

    public PromiseAwareXmlRpcInvocationHandler(XmlRpcClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    protected String getMethodName(Method method) {
        String methodName = method.getName();
        ServiceMethod serviceMethod = method.getAnnotation(ServiceMethod.class);
        if (serviceMethod != null && serviceMethod.value() != null) {
            methodName = serviceMethod.value();
        }
        return methodName;
    }

    protected Vector convertArguments(Object[] objects) {
        if (objects == null) {
            return new Vector();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object o : objects) {
            if (o instanceof Collection) {
                args.add(((Collection)o).toArray());
                continue;
            }
            args.add(o);
        }
        return new Vector(args);
    }

    protected Object convertReturnValue(final Method method, Object returnValue) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (returnValue == null) {
            return null;
        }
        Class beanType = this.getReturnBeanType(method);
        ArrayList collection = null;
        if (returnValue.getClass().isArray()) {
            Object[] objArray = (Object[])returnValue;
            collection = new ArrayList(Arrays.asList(objArray));
            if (beanType != null) {
                collection = this.mapBeanCollection(collection, beanType);
            }
            return collection;
        }
        if (Collection.class.isAssignableFrom(returnValue.getClass())) {
            collection = (ArrayList)returnValue;
            if (beanType != null) {
                collection = this.mapBeanCollection(collection, beanType);
            }
            return collection;
        }
        if (Map.class.isAssignableFrom(returnValue.getClass()) && beanType != null) {
            returnValue = this.mapBean((Map)returnValue, beanType);
        } else if (Promise.class.isAssignableFrom(returnValue.getClass())) {
            returnValue = ((Promise)returnValue).map((Function)new Function<Object, Object>(){

                public Object apply(Object result) {
                    try {
                        return PromiseAwareXmlRpcInvocationHandler.this.convertReturnValue(method, result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return returnValue;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String serviceName = this.getServiceName(method);
        String methodName = this.getMethodName(method);
        try {
            Object returnValue = this.clientProvider.execute(serviceName, methodName, this.convertArguments(args));
            returnValue = this.convertReturnValue(method, returnValue);
            if (returnValue != null && !method.getReturnType().equals(Void.class)) {
                return returnValue;
            }
            return Void.TYPE;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute RPC method " + methodName, e);
        }
    }

    private String getServiceName(Method method) {
        ServiceObject serviceObject = method.getDeclaringClass().getAnnotation(ServiceObject.class);
        return serviceObject.value();
    }

    private Class getReturnBeanType(Method method) {
        Class returnType;
        Type resultType;
        ParameterizedType typeParam;
        if (method.getReturnType().isAnnotationPresent(ServiceBean.class)) {
            return method.getReturnType();
        }
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType && (typeParam = (ParameterizedType)type).getActualTypeArguments().length == 1 && (resultType = typeParam.getActualTypeArguments()[0]) instanceof Class && (returnType = (Class)resultType).isAnnotationPresent(ServiceBean.class)) {
            return returnType;
        }
        return null;
    }

    private ArrayList mapBeanCollection(Collection<Map> result, Class beanType) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> beanCollection = new ArrayList<Object>();
        for (Map map : result) {
            Object beanInstance = this.mapBean(map, beanType);
            beanCollection.add(beanInstance);
        }
        return beanCollection;
    }

    private Object mapBean(Map map, Class beanType) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object beanInstance = beanType.newInstance();
        this.mapToBean(beanInstance, map);
        return beanInstance;
    }

    private void mapToBean(Object bean, Map map) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.populate(bean, this.removeNullValues(this.mapArraysToLists(this.remapPropertyNames(bean, map))));
    }

    private Map mapArraysToLists(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        for (String key : result.keySet()) {
            Object value = result.get(key);
            if (value != null && value.getClass().isArray()) {
                result.put(key, Arrays.asList((Object[])value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Map removeNullValues(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            boolean isEmptyString;
            Object value = map.get(key);
            boolean isString = value instanceof String;
            boolean bl = isEmptyString = isString && value.toString().equals("");
            if (value == null || isEmptyString) continue;
            result.put(key, value);
        }
        return result;
    }

    private Map remapPropertyNames(Object bean, Map map) {
        HashMap result = new HashMap(map);
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(bean)) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) continue;
            ServiceBeanField beanField = writeMethod.getAnnotation(ServiceBeanField.class);
            if (beanField != null && beanField.value() != null && !beanField.value().equals("")) {
                Object data = result.get(beanField.value());
                result.remove(beanField.value());
                result.put(descriptor.getName(), data);
                continue;
            }
            result.put(descriptor.getName(), map.get(descriptor.getName()));
        }
        return result;
    }
}

