/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.plugin.remotable.sisu.Disposable;
import com.atlassian.plugin.remotable.sisu.DisposeException;
import com.atlassian.plugin.remotable.sisu.Disposer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleDisposer
implements Disposer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<Disposable> disposables = new LinkedList();

    public BundleDisposer(Bundle bundle) {
        bundle.getBundleContext().addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 256) {
                    BundleDisposer.this.disposeAll();
                }
            }
        });
    }

    private void disposeAll() {
        Iterator<Disposable> disposablesIterator = new LinkedList<Disposable>(this.disposables).descendingIterator();
        while (disposablesIterator.hasNext()) {
            Disposable d = disposablesIterator.next();
            try {
                d.dispose();
            }
            catch (DisposeException e) {
                this.logger.warn("Could not dispose cleanly of {}, calling {}", d.object, (Object)d.method);
                this.logger.warn("Here is what happened:", (Throwable)e);
            }
        }
    }

    @Override
    public void register(Method method, Object object) {
        this.disposables.add(new Disposable(method, object));
    }
}

