/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.webpanel;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.ConditionProcessor;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.module.webpanel.IFrameRemoteWebPanel;
import com.atlassian.plugin.remotable.plugin.module.webpanel.extractor.WebPanelURLParametersSerializer;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.web.descriptors.DefaultWebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;

public class RemoteWebPanelModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    public static final String REMOTE_WEB_PANEL_MODULE_PREFIX = "remote-web-panel-";
    private final IFrameRendererImpl iFrameRenderer;
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final HostContainer hostContainer;
    private final BundleContext bundleContext;
    private final ConditionProcessor conditionProcessor;
    private final WebPanelURLParametersSerializer webPanelURLParametersSerializer;
    private final UserManager userManager;
    private String weight;
    private URI url;
    private String location;
    private Element descriptor;
    private DynamicDescriptorRegistration.Registration registration;

    public RemoteWebPanelModuleDescriptor(ModuleFactory moduleFactory, IFrameRendererImpl iFrameRenderer, DynamicDescriptorRegistration dynamicDescriptorRegistration, HostContainer hostContainer, BundleContext bundleContext, ConditionProcessor conditionProcessor, WebPanelURLParametersSerializer webPanelURLParametersSerializer, UserManager userManager) {
        super(moduleFactory);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.webPanelURLParametersSerializer = (WebPanelURLParametersSerializer)Preconditions.checkNotNull((Object)webPanelURLParametersSerializer);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.hostContainer = (HostContainer)Preconditions.checkNotNull((Object)hostContainer);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.conditionProcessor = (ConditionProcessor)Preconditions.checkNotNull((Object)conditionProcessor);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
        this.location = this.getLocation(element);
        this.weight = Dom4jUtils.getOptionalAttribute(element, "weight", null);
        this.url = Dom4jUtils.getRequiredUriAttribute(element, "url");
    }

    public void enabled() {
        super.enabled();
        String moduleKey = REMOTE_WEB_PANEL_MODULE_PREFIX + Dom4jUtils.getRequiredAttribute(this.descriptor, "key");
        String panelName = Dom4jUtils.getRequiredAttribute(this.descriptor, "name");
        Element desc = this.descriptor.createCopy();
        desc.addAttribute("key", moduleKey);
        desc.addAttribute("i18n-key", panelName);
        desc.addAttribute("location", this.location);
        if (this.weight != null) {
            desc.addAttribute("weight", this.weight);
        }
        desc.addElement("label").addAttribute("key", panelName);
        desc.addAttribute("class", IFrameRemoteWebPanel.class.getName());
        Condition condition = this.conditionProcessor.process(this.descriptor, desc, this.getPluginKey(), "#" + moduleKey);
        ModuleDescriptor<WebPanel> moduleDescriptor = this.createWebPanelModuleDescriptor(moduleKey, desc, condition, new IFrameParamsImpl(this.descriptor));
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), new DescriptorToRegister(moduleDescriptor));
    }

    public void disabled() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        super.disabled();
    }

    private ModuleDescriptor<WebPanel> createWebPanelModuleDescriptor(final String moduleKey, Element desc, final Condition condition, final IFrameParams iFrameParams) {
        try {
            DefaultWebPanelModuleDescriptor moduleDescriptor = new DefaultWebPanelModuleDescriptor(this.hostContainer, new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    return (T)new IFrameRemoteWebPanel(RemoteWebPanelModuleDescriptor.this.iFrameRenderer, new IFrameContextImpl(RemoteWebPanelModuleDescriptor.this.getPluginKey(), RemoteWebPanelModuleDescriptor.this.url, moduleKey, iFrameParams), (Condition)(condition != null ? condition : new AlwaysDisplayCondition()), RemoteWebPanelModuleDescriptor.this.webPanelURLParametersSerializer, RemoteWebPanelModuleDescriptor.this.userManager);
                }
            }, OsgiServiceUtils.getService(this.bundleContext, WebInterfaceManager.class));
            moduleDescriptor.init(this.conditionProcessor.getLoadablePlugin(this.getPlugin()), desc);
            return moduleDescriptor;
        }
        catch (Exception ex) {
            throw new PluginParseException((Throwable)ex);
        }
    }

    public Void getModule() {
        return null;
    }

    protected String getLocation(Element element) {
        return Dom4jUtils.getRequiredAttribute(element, "location");
    }
}

