/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.loader;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.remotable.api.service.HttpResourceMounter;
import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.host.common.service.AuthenticationFilter;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.BigPipeContentFilter;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.BigPipeRequestIdFilter;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.DefaultBigPipeManager;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBDispatchFilter;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBDocumentationRedirectFilter;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;

public class LocalHttpResourceMounter
implements HttpResourceMounter {
    private final UBDispatchFilter httpResourceFilter;
    private final String appKey;

    public LocalHttpResourceMounter(Plugin plugin, UBDispatchFilter httpResourceFilter, SignedRequestHandler signedRequestHandler, RequestContext requestContext, DefaultBigPipeManager bigPipeManager) {
        this.httpResourceFilter = httpResourceFilter;
        this.appKey = plugin.getKey();
        this.mountFilter(new BigPipeRequestIdFilter(bigPipeManager), "/*");
        this.mountFilter(new UBDocumentationRedirectFilter(plugin), "/");
        this.mountFilter(new AuthenticationFilter(signedRequestHandler, requestContext), "/*");
        this.mountFilter(new BigPipeContentFilter(bigPipeManager), "/bigpipe/request/*");
    }

    @Override
    public String getLocalMountBaseUrl() {
        return this.httpResourceFilter.getLocalMountBaseUrl(this.appKey);
    }

    @Override
    public void mountFilter(Filter filter, String ... urlPatterns) {
        this.httpResourceFilter.mountFilter(this.appKey, filter, urlPatterns);
    }

    @Override
    public void mountServlet(HttpServlet httpServlet, String ... urlPatterns) {
        this.httpResourceFilter.mountServlet(this.appKey, httpServlet, urlPatterns);
    }

    @Override
    public void mountStaticResources(String resourcePrefix, String urlPattern) {
        this.httpResourceFilter.mountResources(this.appKey, resourcePrefix, urlPattern);
    }
}

