/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.util.decorators;

import com.google.inject.matcher.Matcher;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceUnavailableException;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.util.DelegatingImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptingDecorator<S>
implements ImportDecorator<S> {
    final Matcher<? super Class<?>> classMatcher;
    final Matcher<? super Method> methodMatcher;
    final MethodInterceptor[] interceptors;

    public InterceptingDecorator(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this.classMatcher = classMatcher;
        this.methodMatcher = methodMatcher;
        this.interceptors = interceptors;
        if (interceptors.length == 0) {
            throw new IllegalArgumentException("Must provide at least one method interceptor");
        }
    }

    static Class<?>[] getInterfaces(Object instance) {
        HashSet api = new HashSet();
        for (Class<?> clazz = instance.getClass(); null != clazz; clazz = clazz.getSuperclass()) {
            Collections.addAll(api, clazz.getInterfaces());
        }
        return api.toArray(new Class[api.size()]);
    }

    @Override
    public <T extends S> Import<T> decorate(Import<T> service) {
        return new ProxyImport<T>(service);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProxyImport<T>
    extends DelegatingImport<T>
    implements InvocationHandler {
        private volatile T proxy;

        ProxyImport(Import<T> service) {
            super(service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (null == this.proxy) {
                ProxyImport proxyImport = this;
                synchronized (proxyImport) {
                    try {
                        Object instance = super.get();
                        if (null == this.proxy && null != instance) {
                            ClassLoader loader = InterceptingDecorator.this.interceptors[0].getClass().getClassLoader();
                            this.proxy = Proxy.newProxyInstance(loader, InterceptingDecorator.getInterfaces(instance), (InvocationHandler)this);
                        }
                    }
                    finally {
                        super.unget();
                    }
                }
            }
            return this.proxy;
        }

        @Override
        public void unget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object unused, Method method, Object[] args) throws Throwable {
            try {
                Object instance = super.get();
                if (null == instance) {
                    throw new ServiceUnavailableException();
                }
                if (!InterceptingDecorator.this.methodMatcher.matches(method) || !InterceptingDecorator.this.classMatcher.matches(method.getDeclaringClass())) {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                Object object = this.intercept(instance, method, args);
                return object;
            }
            finally {
                super.unget();
            }
        }

        private Object intercept(final Object instance, final Method method, final Object[] args) throws Throwable {
            return InterceptingDecorator.this.interceptors[0].invoke(new MethodInvocation(){
                private int index = 1;

                public AccessibleObject getStaticPart() {
                    return method;
                }

                public Method getMethod() {
                    return method;
                }

                public Object[] getArguments() {
                    return args;
                }

                public Object getThis() {
                    return instance;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object proceed() throws Throwable {
                    try {
                        if (this.index < InterceptingDecorator.this.interceptors.length) {
                            Object object = InterceptingDecorator.this.interceptors[this.index++].invoke(this);
                            return object;
                        }
                        Object object = method.invoke(instance, args);
                        return object;
                    }
                    finally {
                        --this.index;
                    }
                }
            });
        }
    }
}

