/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import org.ops4j.peaberry.ServiceRegistry;
import org.ops4j.peaberry.builders.DecoratedServiceBuilder;
import org.ops4j.peaberry.internal.ServiceBuilderImpl;
import org.ops4j.peaberry.osgi.OSGiModule;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Peaberry {
    public static final String CACHE_INTERVAL_HINT = "org.ops4j.peaberry.cache.interval";
    public static final String CACHE_GENERATIONS_HINT = "org.ops4j.peaberry.cache.generations";
    public static final String NATIVE_FILTER_HINT = "org.ops4j.peaberry.filter.native";

    private Peaberry() {
    }

    public static <T> DecoratedServiceBuilder<T> service(Key<T> key) {
        return new ServiceBuilderImpl<Key<T>>(key);
    }

    public static <T> DecoratedServiceBuilder<T> service(TypeLiteral<T> type) {
        return new ServiceBuilderImpl<Key<T>>(Key.get(type));
    }

    public static <T> DecoratedServiceBuilder<T> service(Class<T> clazz) {
        return new ServiceBuilderImpl<Key<T>>(Key.get(clazz));
    }

    public static <T> DecoratedServiceBuilder<T> service(T instance) {
        return new ServiceBuilderImpl<T>(instance);
    }

    public static Module osgiModule(BundleContext bundleContext) {
        return new OSGiModule(bundleContext, new ServiceRegistry[0]);
    }

    public static Module osgiModule(BundleContext bundleContext, ServiceRegistry ... registries) {
        return new OSGiModule(bundleContext, registries);
    }

    public static Module osgiModule(ServiceRegistry ... registries) {
        return new OSGiModule(registries);
    }
}

