/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.spi.permission.scope;

import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.util.ServletUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class RestApiScopeHelper {
    private final Iterable<RestScope> scopes;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private static final Function<String, String> LOWERCASE_TRANSFORM = new Function<String, String>(){

        public String apply(String from) {
            return from.toLowerCase(Locale.US);
        }
    };

    public RestApiScopeHelper(Iterable<RestScope> scopes) {
        this.scopes = scopes;
        this.apiResourceInfo = Iterables.concat((Iterable)Iterables.transform(scopes, (Function)new Function<RestScope, Iterable<ApiResourceInfo>>(){

            public Iterable<ApiResourceInfo> apply(RestScope from) {
                return from.getApiResourceInfo();
            }
        }));
    }

    public boolean allow(HttpServletRequest request, String user) {
        String pathInfo = ServletUtils.extractPathInfo(request);
        String[] elements = StringUtils.split((String)pathInfo, (char)'/');
        if (elements.length > 2 && "rest".equals(elements[0])) {
            String name = elements[1];
            String version = elements[2].toLowerCase(Locale.US);
            String method = request.getMethod().toLowerCase(Locale.US);
            String path = StringUtils.join((Object[])Arrays.copyOfRange(elements, 3, elements.length), (String)"/");
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            for (RestScope scope : this.scopes) {
                if (!scope.match(name, version, path, method)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    public static class RestScope {
        private final String name;
        private final Collection<String> versions;
        private final String basePath;
        private final Collection<String> methods;

        public RestScope(String name, Collection<String> versions, String basePath, Collection<String> methods) {
            this.name = name;
            this.versions = Collections2.transform(versions, (Function)LOWERCASE_TRANSFORM);
            this.basePath = basePath;
            this.methods = Collections2.transform(methods, (Function)LOWERCASE_TRANSFORM);
        }

        public String getName() {
            return this.name;
        }

        public boolean match(String name, String version, String path, String method) {
            return this.name.equalsIgnoreCase(name) && this.versions.contains(version) && path.startsWith(this.basePath) && this.methods.contains(method);
        }

        public Iterable<ApiResourceInfo> getApiResourceInfo() {
            ArrayList infos = Lists.newArrayList();
            for (String version : this.versions) {
                for (String method : this.methods) {
                    StringBuilder sb = new StringBuilder("/rest/").append(this.name).append("/").append(version).append(this.basePath);
                    infos.add(new ApiResourceInfo(sb.toString(), method.toUpperCase(Locale.US)));
                }
            }
            return infos;
        }
    }
}

