/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.plugin.remotable.api.annotation.ComponentImport;
import com.google.inject.Binder;
import com.google.inject.Key;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sisu.binders.Wiring;
import org.ops4j.peaberry.Peaberry;

public final class ComponentImportWiring
implements Wiring {
    private final Set<Class<?>> classes = new HashSet();
    private final Binder binder;

    public ComponentImportWiring(Binder binder) {
        this.binder = binder;
    }

    public boolean wire(Key<?> key) {
        Class<?> beanClass = key.getTypeLiteral().getRawType();
        if (key.getAnnotation() instanceof ComponentImport) {
            this.addOsgiServiceFor(beanClass);
            return true;
        }
        return false;
    }

    private <T> void addOsgiServiceFor(Class<T> aClass) {
        if (!this.classes.contains(aClass)) {
            this.binder.bind(aClass).annotatedWith(ComponentImport.class).toProvider(Peaberry.service(aClass).single());
            this.classes.add(aClass);
        }
    }
}

