/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util;

import com.atlassian.oauth.Request;
import com.atlassian.oauth.util.Check;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;

public class OAuthHelper {
    private static final Function<Request.Parameter, OAuth.Parameter> toOAuthParameters = new Function<Request.Parameter, OAuth.Parameter>(){

        public OAuth.Parameter apply(Request.Parameter p) {
            Check.notNull((Object)p, (Object)"parameter");
            return new OAuth.Parameter(p.getName(), p.getValue());
        }
    };

    public static OAuthMessage asOAuthMessage(Request request) {
        Check.notNull((Object)request, (Object)"request");
        return new OAuthMessage(request.getMethod().name(), request.getUri().toString(), (Collection)ImmutableList.copyOf(OAuthHelper.asOAuthParameters(request.getParameters())));
    }

    public static Iterable<OAuth.Parameter> asOAuthParameters(Iterable<Request.Parameter> requestParameters) {
        Check.notNull(requestParameters, (Object)"requestParameters");
        return Iterables.transform(requestParameters, toOAuthParameters);
    }
}

