/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.page;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.DefaultWebItemContext;
import com.atlassian.plugin.remotable.plugin.module.page.RemotePageDescriptorCreator;
import com.atlassian.plugin.remotable.spi.module.UserIsAdminCondition;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import org.dom4j.Element;

public final class AdminPageModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final RemotePageDescriptorCreator remotePageDescriptorCreator;
    private final ProductAccessor productAccessor;
    private final UserIsAdminCondition userIsAdminCondition;
    private Element descriptor;
    private DynamicDescriptorRegistration.Registration registration;

    public AdminPageModuleDescriptor(ModuleFactory moduleFactory, DynamicDescriptorRegistration dynamicDescriptorRegistration, ProductAccessor productAccessor, RemotePageDescriptorCreator remotePageDescriptorCreator, UserIsAdminCondition userIsAdminCondition) {
        super(moduleFactory);
        this.productAccessor = productAccessor;
        this.userIsAdminCondition = userIsAdminCondition;
        this.remotePageDescriptorCreator = (RemotePageDescriptorCreator)Preconditions.checkNotNull((Object)remotePageDescriptorCreator);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
    }

    public void enabled() {
        super.enabled();
        String sectionKey = Dom4jUtils.getOptionalAttribute(this.descriptor, "section", this.productAccessor.getPreferredAdminSectionKey());
        Integer weight = Integer.valueOf(Dom4jUtils.getOptionalAttribute(this.descriptor, "weight", this.productAccessor.getPreferredAdminWeight()));
        RemotePageDescriptorCreator.Builder remotePageDescriptorBuilder = this.remotePageDescriptorCreator.newBuilder().setWebItemContext(new DefaultWebItemContext(sectionKey, weight, this.productAccessor.getLinkContextParams())).setDecorator("atl.admin").setCondition(this.userIsAdminCondition);
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), remotePageDescriptorBuilder.build(this.getPlugin(), this.descriptor));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

