/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.descriptor.DescribedModuleDescriptorFactoryAccessor;
import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidatorProvider;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.permission.PermissionsReader;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.spi.Schema;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDescriptorValidatorProvider
implements DescriptorValidatorProvider {
    private final Plugin plugin;
    private final ApplicationProperties applicationProperties;
    private final DescribedModuleDescriptorFactoryAccessor describedModuleDescriptorFactoryAccessor;
    private final PermissionsReader permissionsReader;
    private final PermissionManager permissionManager;

    @Autowired
    public PluginDescriptorValidatorProvider(PluginRetrievalService pluginRetrievalService, ApplicationProperties applicationProperties, DescribedModuleDescriptorFactoryAccessor describedModuleDescriptorFactoryAccessor, PermissionsReader permissionsReader, PermissionManager permissionManager) {
        this.plugin = ((PluginRetrievalService)Preconditions.checkNotNull((Object)pluginRetrievalService)).getPlugin();
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.describedModuleDescriptorFactoryAccessor = (DescribedModuleDescriptorFactoryAccessor)Preconditions.checkNotNull((Object)describedModuleDescriptorFactoryAccessor);
        this.permissionsReader = (PermissionsReader)Preconditions.checkNotNull((Object)permissionsReader);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
    }

    @Override
    public String getSchemaNamespace(InstallationMode installationMode) {
        return String.format("%s/rest/remotable-plugins/1%s%s", this.applicationProperties.getBaseUrl(), "/installer", installationMode == InstallationMode.REMOTE ? "/schema/atlassian-plugin-remotable" : "/schema/atlassian-plugin");
    }

    @Override
    public String getRootElementName() {
        return "AtlassianPluginType";
    }

    @Override
    public Iterable<Schema> getModuleSchemas(final InstallationMode mode) {
        return Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(this.describedModuleDescriptorFactoryAccessor.getDescribedModuleDescriptorFactories(), (Function)new Function<DescribedModuleDescriptorFactory, Iterable<Schema>>(){

            public Iterable<Schema> apply(DescribedModuleDescriptorFactory factory) {
                return PluginDescriptorValidatorProvider.this.getModuleSchemas(factory, mode);
            }
        })), (Predicate)Predicates.notNull());
    }

    private Iterable<Schema> getModuleSchemas(final DescribedModuleDescriptorFactory factory, final InstallationMode mode) {
        return Iterables.transform((Iterable)factory.getModuleDescriptorKeys(), (Function)new Function<String, Schema>(){

            public Schema apply(String key) {
                return PluginDescriptorValidatorProvider.this.getModuleSchema(factory, mode, key);
            }
        });
    }

    private Schema getModuleSchema(DescribedModuleDescriptorFactory factory, InstallationMode mode, String key) {
        Schema schema = factory.getSchema(key);
        if (schema == null) {
            return null;
        }
        Set<String> allowedPermissions = this.permissionManager.getPermissionKeys(mode);
        if (allowedPermissions.isEmpty()) {
            return schema;
        }
        ImmutableSet requiredPermissions = ImmutableSet.copyOf((Iterable)schema.getRequiredPermissions());
        if (Sets.difference((Set)requiredPermissions, allowedPermissions).isEmpty()) {
            return schema;
        }
        return null;
    }

    @Override
    public void performSecondaryValidations(Document document) throws InstallationFailedException {
        Set<String> permissions = this.permissionsReader.readPermissionsFromDescriptor(document, InstallationMode.REMOTE);
        Collection moduleTypes = Collections2.transform((Collection)document.getRootElement().elements(), (Function)new Function<Element, String>(){

            public String apply(Element input) {
                return input.getName();
            }
        });
        for (DescribedModuleDescriptorFactory factory : this.describedModuleDescriptorFactoryAccessor.getDescribedModuleDescriptorFactories()) {
            for (String key : factory.getModuleDescriptorKeys()) {
                if (!moduleTypes.contains(key)) continue;
                for (String permission : factory.getSchema(key).getRequiredPermissions()) {
                    if (permissions.contains(permission)) continue;
                    throw new InstallationFailedException("The permission '" + permission + " is required " + "to use the '" + key + "' module type");
                }
            }
        }
    }

    @Override
    public URL getSchemaUrl() {
        return this.plugin.getResource("/xsd/atlassian-plugin.xsd");
    }
}

