/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.remotable.api.annotation.PublicComponent;
import com.atlassian.plugin.remotable.sisu.AbstractAnnotatedClassTypeListener;
import com.atlassian.plugin.remotable.sisu.ContextClassLoaderSettingInvocationHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

final class PublicComponentAnnotatedClassTypeListener
extends AbstractAnnotatedClassTypeListener<PublicComponent> {
    private final BundleContext bundleContext;

    PublicComponentAnnotatedClassTypeListener(BundleContext bundleContext) {
        super(PublicComponent.class);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
    }

    @Override
    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter, final PublicComponent annotation) {
        Object[] interfaces = new String[annotation.value().length];
        for (int x = 0; x < annotation.value().length; ++x) {
            interfaces[x] = annotation.value()[x].getName();
        }
        final Class<I> clazz = type.getRawType();
        final Provider<I> provider = encounter.getProvider(clazz);
        final String interfacesAsString = Arrays.toString(interfaces);
        this.logger.debug("Registering service (public component) implementation {} as {}", clazz, (Object)interfacesAsString);
        this.bundleContext.registerService((String[])interfaces, (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                PublicComponentAnnotatedClassTypeListener.this.logger.debug("Bundle {} is getting a service reference for {} exposed as {}", new Object[]{bundle, clazz, interfacesAsString});
                return PublicComponentAnnotatedClassTypeListener.wrapService(annotation.value(), (Supplier<Object>)new ServiceSupplier(clazz, provider, bundle, registration), clazz.getClassLoader(), (Option<String>)Option.some((Object)("Proxy(" + clazz.getName() + ")")));
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                PublicComponentAnnotatedClassTypeListener.this.logger.debug("Bundle {} is un-getting a service reference for {} exposed as {}", new Object[]{bundle, clazz, interfacesAsString});
                Object provided = provider.get();
                if (provided instanceof ServiceFactory) {
                    ((ServiceFactory)provided).ungetService(bundle, registration, service);
                }
            }
        }, null);
    }

    private static Object wrapService(Class<?>[] interfaces, Supplier<Object> service, ClassLoader classLoader, Option<String> toString) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler(service, toString));
    }

    private static final class ServiceSupplier
    implements Supplier<Object> {
        private final Class<?> clazz;
        private final Provider<?> provider;
        private final Bundle bundle;
        private final ServiceRegistration registration;

        public ServiceSupplier(Class<?> clazz, Provider<?> provider, Bundle bundle, ServiceRegistration registration) {
            this.clazz = clazz;
            this.provider = provider;
            this.bundle = bundle;
            this.registration = registration;
        }

        public Object get() {
            Object service = this.provider.get();
            if (service instanceof ServiceFactory) {
                ServiceFactory serviceFactory = (ServiceFactory)PublicComponentAnnotatedClassTypeListener.wrapService(new Class[]{ServiceFactory.class}, (Supplier<Object>)Suppliers.ofInstance(service), this.clazz.getClassLoader(), (Option<String>)Option.none());
                return serviceFactory.getService(this.bundle, this.registration);
            }
            return service;
        }
    }
}

