/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.oauth;

import com.atlassian.oauth.util.Check;
import com.atlassian.plugin.remotable.plugin.product.WebSudoElevator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.server.HttpRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2LOFilter
implements Filter {
    public static final String USER_ID = "user_id";
    public static final String USER_KEY = "user_key";
    private static final Set<String> OAUTH_DATA_REQUEST_PARAMS = ImmutableSet.of((Object)"oauth_consumer_key", (Object)"oauth_signature_method", (Object)"oauth_signature", (Object)"oauth_timestamp", (Object)"oauth_nonce");
    private static final Logger log = LoggerFactory.getLogger(OAuth2LOFilter.class);
    private final Authenticator authenticator;
    private final AuthenticationListener authenticationListener;
    private final AuthenticationController authenticationController;
    private final WebSudoElevator webSudoElevator;
    private final ApplicationProperties applicationProperties;

    public OAuth2LOFilter(Authenticator authenticator, AuthenticationListener authenticationListener, AuthenticationController authenticationController, WebSudoElevator webSudoElevator, ApplicationProperties applicationProperties) {
        this.webSudoElevator = (WebSudoElevator)Check.notNull((Object)webSudoElevator, (Object)"webSudoElevator");
        this.authenticator = (Authenticator)Check.notNull((Object)authenticator, (Object)"authenticator");
        this.authenticationListener = (AuthenticationListener)Check.notNull((Object)authenticationListener, (Object)"authenticationListener");
        this.authenticationController = (AuthenticationController)Check.notNull((Object)authenticationController, (Object)"authenticationController");
        this.applicationProperties = (ApplicationProperties)Check.notNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            if (!this.mayProceed(request, response)) {
                return;
            }
        }
        catch (RuntimeException ex) {
            if (!ex.getClass().getSimpleName().equals("ServiceProxyDestroyedException")) {
                throw ex;
            }
            log.debug(ex.toString());
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (this.isOAuth2LOAccessAttempt(request) && request.getSession(false) != null) {
                request.getSession().invalidate();
            }
        }
    }

    boolean mayProceed(HttpServletRequest request, HttpServletResponse response) {
        if (!this.authenticationController.shouldAttemptAuthentication(request)) {
            this.authenticationListener.authenticationNotAttempted(request, response);
            return true;
        }
        if (!this.isOAuth2LOAccessAttempt(request)) {
            this.authenticationListener.authenticationNotAttempted(request, response);
            return true;
        }
        Authenticator.Result result = this.authenticator.authenticate(request, response);
        if (result.getStatus() == Authenticator.Result.Status.FAILED) {
            this.authenticationListener.authenticationFailure(result, request, response);
            return false;
        }
        if (result.getStatus() == Authenticator.Result.Status.ERROR) {
            this.authenticationListener.authenticationError(result, request, response);
            return false;
        }
        if (result.getStatus() == Authenticator.Result.Status.SUCCESS) {
            this.authenticationListener.authenticationSuccess(result, request, response);
            this.webSudoElevator.startWebSudoSession(request, response);
        }
        return true;
    }

    private boolean isOAuth2LOAccessAttempt(HttpServletRequest request) {
        Set<String> names = this.parameterNames(request);
        return names.containsAll(OAUTH_DATA_REQUEST_PARAMS) && !names.contains("oauth_token") && !this.isTokenRequest(request) && !this.isDownloadableResourceRequest(request);
    }

    private boolean isDownloadableResourceRequest(HttpServletRequest request) {
        return request.getRequestURI().startsWith(this.getContextPath(request) + "/download/resources/");
    }

    private boolean isTokenRequest(HttpServletRequest request) {
        return request.getRequestURL().toString().endsWith("/plugins/servlet/oauth/request-token");
    }

    private String getContextPath(HttpServletRequest request) {
        String baseUrl = this.applicationProperties.getBaseUrl();
        if (baseUrl == null) {
            return request.getContextPath();
        }
        return URI.create(baseUrl).getPath();
    }

    private Set<String> parameterNames(HttpServletRequest request) {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (OAuth.Parameter parameter : HttpRequestMessage.getParameters(request)) {
            names.add((Object)parameter.getKey());
        }
        return names.build();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

