/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.oldscopes.jira;

import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.spi.permission.AbstractPermission;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.JsonRpcApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.RpcEncodedSoapApiScopeHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

abstract class JiraScope
extends AbstractPermission
implements ApiScope {
    private final RpcEncodedSoapApiScopeHelper soapScopeHelper;
    private final JsonRpcApiScopeHelper jsonRpcScopeHelper;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private final RestApiScopeHelper restApiScopeHelper;

    protected JiraScope(String key, Collection<String> methods, Collection<RestApiScopeHelper.RestScope> resources) {
        super(key, (Set)ImmutableSet.of((Object)InstallationMode.LOCAL, (Object)InstallationMode.REMOTE));
        this.soapScopeHelper = new RpcEncodedSoapApiScopeHelper("/rpc/soap/jirasoapservice-v2", "http://soap.rpc.jira.atlassian.com", (Collection)Preconditions.checkNotNull(methods));
        this.jsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/jirasoapservice-v2", methods);
        this.restApiScopeHelper = new RestApiScopeHelper((Iterable)Preconditions.checkNotNull(resources));
        this.apiResourceInfo = Iterables.concat((Iterable)this.soapScopeHelper.getApiResourceInfos(), (Iterable)this.jsonRpcScopeHelper.getApiResourceInfos(), (Iterable)this.restApiScopeHelper.getApiResourceInfos());
    }

    public final boolean allow(HttpServletRequest request, String user) {
        return this.soapScopeHelper.allow(request, user) || this.jsonRpcScopeHelper.allow(request, user) || this.restApiScopeHelper.allow(request, user);
    }

    public final Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }
}

