/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.oldscopes.confluence;

import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.spi.permission.AbstractPermission;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.DownloadScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.JsonRpcApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.XmlRpcApiScopeHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

abstract class ConfluenceScope
extends AbstractPermission
implements ApiScope {
    private final XmlRpcApiScopeHelper v2XmlRpcApiScopeHelper;
    private final XmlRpcApiScopeHelper v1XmlRpcApiScopeHelper;
    private final JsonRpcApiScopeHelper v2JsonRpcScopeHelper;
    private final JsonRpcApiScopeHelper v1JsonRpcScopeHelper;
    private final RestApiScopeHelper restApiScopeHelper;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private final DownloadScopeHelper downloadScopeHelper;

    protected ConfluenceScope(String key, Collection<String> methods) {
        this(key, methods, Collections.emptyList(), new DownloadScopeHelper(new String[0]));
    }

    protected ConfluenceScope(String key, Collection<String> methods, Collection<RestApiScopeHelper.RestScope> resources) {
        this(key, methods, resources, new DownloadScopeHelper(new String[0]));
    }

    protected ConfluenceScope(String key, Collection<String> methods, DownloadScopeHelper downloadScopeHelper) {
        this(key, methods, Collections.emptyList(), downloadScopeHelper);
    }

    protected ConfluenceScope(String key, Collection<String> methods, Collection<RestApiScopeHelper.RestScope> resources, DownloadScopeHelper downloadScopeHelper) {
        super(key, (Set)ImmutableSet.of((Object)InstallationMode.LOCAL, (Object)InstallationMode.REMOTE));
        this.v1JsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/confluenceservice-v1", methods);
        this.v2JsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/confluenceservice-v2", methods);
        this.v1XmlRpcApiScopeHelper = new XmlRpcApiScopeHelper("/rpc/xmlrpc", Collections2.transform(methods, this.xmlRpcTransform("confluence1")));
        this.v2XmlRpcApiScopeHelper = new XmlRpcApiScopeHelper("/rpc/xmlrpc", Collections2.transform(methods, this.xmlRpcTransform("confluence2")));
        this.restApiScopeHelper = new RestApiScopeHelper((Iterable)Preconditions.checkNotNull(resources));
        this.downloadScopeHelper = (DownloadScopeHelper)Preconditions.checkNotNull((Object)downloadScopeHelper);
        this.apiResourceInfo = Iterables.concat((Iterable[])new Iterable[]{this.v1JsonRpcScopeHelper.getApiResourceInfos(), this.v2JsonRpcScopeHelper.getApiResourceInfos(), this.v1XmlRpcApiScopeHelper.getApiResourceInfos(), this.v2XmlRpcApiScopeHelper.getApiResourceInfos(), downloadScopeHelper.getApiResourceInfos()});
    }

    public final boolean allow(HttpServletRequest request, String user) {
        return this.v1XmlRpcApiScopeHelper.allow(request, user) || this.v2XmlRpcApiScopeHelper.allow(request, user) || this.v1JsonRpcScopeHelper.allow(request, user) || this.v2JsonRpcScopeHelper.allow(request, user) || this.restApiScopeHelper.allow(request, user) || this.downloadScopeHelper.allow(request, user);
    }

    public final Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    private Function<String, String> xmlRpcTransform(final String serviceName) {
        return new Function<String, String>(){

            public String apply(String from) {
                return serviceName + "." + from;
            }
        };
    }
}

