/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.node;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import com.atlassian.plugin.remotable.plugin.util.node.ValueNode;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.dom4j.Element;

public class Dom4jNode
implements Node {
    private final Element element;

    public Dom4jNode(Element element) {
        this.element = element;
    }

    @Override
    public Node get(String propertyName) {
        String val = this.element.attributeValue(propertyName);
        if (val == null) {
            Element child = this.element.element(propertyName);
            if (child == null) {
                return Node.MISSING;
            }
            return new Dom4jNode(child);
        }
        return new ValueNode(val);
    }

    @Override
    public Iterable<Node> getChildren(String nodeName) {
        return Iterables.transform((Iterable)this.element.elements(nodeName), (Function)new Function<Object, Node>(){

            public Node apply(Object input) {
                return new Dom4jNode((Element)input);
            }
        });
    }

    @Override
    public String asString() {
        if (this.element.getText() != null) {
            return this.element.getTextTrim();
        }
        throw new PluginParseException("String value not found");
    }

    @Override
    public String asString(String defaultValue) {
        if (this.element.getText() != null) {
            return this.element.getTextTrim();
        }
        return defaultValue;
    }

    public String toString() {
        return this.asString("null");
    }

    @Override
    public URI asURI() {
        return URI.create(this.asString());
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.asString());
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return Boolean.parseBoolean(this.asString(Boolean.toString(defaultValue)));
    }
}

