/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.confluence;

import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class MacroVariableInjectorTransformer
implements WebResourceTransformer {
    private static final String THIS_PLUGIN_KEY = "com.atlassian.labs.remoteapps-plugin";
    private final Plugin thisPlugin;
    private final I18NBeanFactory userI18NBeanFactory;

    public MacroVariableInjectorTransformer(PluginAccessor pluginAccessor, I18NBeanFactory userI18NBeanFactory) {
        this.userI18NBeanFactory = userI18NBeanFactory;
        this.thisPlugin = pluginAccessor.getPlugin(THIS_PLUGIN_KEY);
    }

    public DownloadableResource transform(final Element configElement, final ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new CharSequenceDownloadableResource((DownloadableResource)new DownloadableClasspathResource(this.thisPlugin, location, "")){

            protected CharSequence transform(CharSequence original) {
                String originalS = ((Object)original).toString();
                for (Element var : configElement.elements("var")) {
                    String value = var.attributeValue("value");
                    if (var.attribute("i18n-key") != null) {
                        value = MacroVariableInjectorTransformer.this.getText(var.attributeValue("i18n-key"), new String[]{value});
                    }
                    String escapedValue = location.getLocation().endsWith(".css") ? value : StringEscapeUtils.escapeJavaScript((String)value);
                    originalS = originalS.replace("%%" + var.attributeValue("name") + "%%", escapedValue);
                }
                return originalS;
            }
        };
    }

    private String getText(String key, String ... values) {
        return this.userI18NBeanFactory.getI18NBean().getText(key, (Object[])values);
    }
}

