/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.page;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.WebItemContext;
import com.atlassian.plugin.remotable.plugin.module.WebItemCreator;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.module.page.IFramePageServlet;
import com.atlassian.plugin.remotable.plugin.module.page.PageInfo;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RemotePageDescriptorCreator {
    private final BundleContext bundleContext;
    private final UserManager userManager;
    private final WebItemCreator webItemCreator;
    private final IFrameRendererImpl iFrameRenderer;
    private final ProductAccessor productAccessor;

    @Autowired
    public RemotePageDescriptorCreator(BundleContext bundleContext, UserManager userManager, WebItemCreator webItemCreator, IFrameRendererImpl iFrameRenderer, ProductAccessor productAccessor) {
        this.bundleContext = bundleContext;
        this.userManager = userManager;
        this.webItemCreator = webItemCreator;
        this.iFrameRenderer = iFrameRenderer;
        this.productAccessor = productAccessor;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public static URI createLocalUrl(String pluginKey, String pageUrl) {
        return URI.create("/remotable-plugins/" + pluginKey + (pageUrl.startsWith("/") ? "" : "/") + pageUrl);
    }

    public class Builder {
        private WebItemCreator.Builder webItemCreatorBuilder;
        private String decorator = "";
        private String templateSuffix = "";
        private Condition condition = new AlwaysDisplayCondition();
        private Map<String, String> metaTagsContent = Maps.newHashMap();

        public Builder() {
            this.webItemCreatorBuilder = RemotePageDescriptorCreator.this.webItemCreator.newBuilder();
            this.webItemCreatorBuilder.setPreferredWeight(RemotePageDescriptorCreator.this.productAccessor.getPreferredGeneralWeight());
            this.webItemCreatorBuilder.setPreferredSectionKey(RemotePageDescriptorCreator.this.productAccessor.getPreferredGeneralSectionKey());
            this.webItemCreatorBuilder.setContextParams(RemotePageDescriptorCreator.this.productAccessor.getLinkContextParams());
            this.webItemCreatorBuilder.setCondition(this.condition.getClass());
        }

        public Iterable<DescriptorToRegister> build(Plugin plugin, Node descriptor) {
            Preconditions.checkNotNull((Object)this.decorator);
            String key = descriptor.get("key").asString();
            URI url = descriptor.get("url").asURI();
            URI localUrl = RemotePageDescriptorCreator.createLocalUrl(plugin.getKey(), key);
            DescriptorToRegister webItemModuleDescriptor = new DescriptorToRegister((ModuleDescriptor)this.webItemCreatorBuilder.build(plugin, key, localUrl, descriptor));
            return ImmutableSet.of((Object)this.createServletDescriptor(plugin, descriptor, key, url, localUrl), (Object)webItemModuleDescriptor);
        }

        private DescriptorToRegister createServletDescriptor(final Plugin plugin, Node e, String key, final URI path, URI localUrl) {
            final String pageName = e.get("name").asString();
            Element config = DocumentHelper.createElement((String)"servlet");
            final String moduleKey = "servlet-" + key;
            config.addAttribute("key", moduleKey);
            config.addAttribute("system", "true");
            config.addAttribute("class", IFramePageServlet.class.getName());
            config.addElement("url-pattern").setText(localUrl + "");
            config.addElement("url-pattern").setText(localUrl + "/*");
            final IFrameParamsImpl params = new IFrameParamsImpl(e);
            ServletModuleDescriptor descriptor = new ServletModuleDescriptor(new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    PageInfo pageInfo = new PageInfo(Builder.this.decorator, Builder.this.templateSuffix, pageName, Builder.this.condition, Builder.this.metaTagsContent);
                    return (T)((Object)new IFramePageServlet(pageInfo, RemotePageDescriptorCreator.this.iFrameRenderer, new IFrameContextImpl(plugin.getKey(), path, moduleKey, params), RemotePageDescriptorCreator.this.userManager));
                }
            }, OsgiServiceUtils.getService(RemotePageDescriptorCreator.this.bundleContext, ServletModuleManager.class));
            descriptor.init(plugin, config);
            return new DescriptorToRegister((ModuleDescriptor)descriptor);
        }

        public Builder setDecorator(String decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder setTemplateSuffix(String templateSuffix) {
            this.templateSuffix = templateSuffix;
            return this;
        }

        public Builder setCondition(Condition condition) {
            this.condition = condition;
            this.webItemCreatorBuilder.setCondition(condition.getClass());
            return this;
        }

        public Builder setWebItemStyleClass(String webItemStyleClass) {
            this.webItemCreatorBuilder.setAdditionalStyleClass(webItemStyleClass);
            return this;
        }

        public Builder setWebItemContext(WebItemContext webItemContext) {
            this.webItemCreatorBuilder.setContextParams(webItemContext.getContextParams()).setPreferredSectionKey(webItemContext.getPreferredSectionKey()).setPreferredWeight(webItemContext.getPreferredWeight());
            return this;
        }

        public Builder setMetaTagContent(String name, String content) {
            this.metaTagsContent.put(name, content);
            return this;
        }
    }
}

