/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.confluence;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.confluence.MacroContentManager;
import com.atlassian.plugin.remotable.plugin.module.confluence.MacroModuleDescriptorCreator;
import com.atlassian.plugin.remotable.plugin.module.confluence.RemoteMacro;
import com.atlassian.plugin.remotable.plugin.module.confluence.RemoteMacroInfo;
import com.atlassian.plugin.remotable.plugin.module.confluence.StorageFormatMacro;
import com.atlassian.plugin.remotable.plugin.util.node.Dom4jNode;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import org.dom4j.Element;

public final class RemoteMacroModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final MacroModuleDescriptorCreator.Builder macroModuleDescriptorCreatorBuilder;
    private Element descriptor;
    private DynamicDescriptorRegistration.Registration registration;

    public RemoteMacroModuleDescriptor(ModuleFactory moduleFactory, DynamicDescriptorRegistration dynamicDescriptorRegistration, MacroModuleDescriptorCreator macroModuleDescriptorCreator, MacroContentManager macroContentManager, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory) {
        super(moduleFactory);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.macroModuleDescriptorCreatorBuilder = RemoteMacroModuleDescriptor.newMacroModuleDescriptorCreatorBuilder((MacroModuleDescriptorCreator)Preconditions.checkNotNull((Object)macroModuleDescriptorCreator), (MacroContentManager)Preconditions.checkNotNull((Object)macroContentManager), (DefaultRemotablePluginAccessorFactory)Preconditions.checkNotNull((Object)remotablePluginAccessorFactory));
    }

    private static MacroModuleDescriptorCreator.Builder newMacroModuleDescriptorCreatorBuilder(MacroModuleDescriptorCreator macroModuleDescriptorCreator, final MacroContentManager macroContentManager, final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory) {
        return macroModuleDescriptorCreator.newBuilder().setMacroFactory(new MacroModuleDescriptorCreator.MacroFactory(){

            @Override
            public RemoteMacro create(RemoteMacroInfo remoteMacroInfo) {
                return new StorageFormatMacro(remoteMacroInfo, macroContentManager, remotablePluginAccessorFactory);
            }
        });
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
    }

    public void enabled() {
        super.enabled();
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), this.macroModuleDescriptorCreatorBuilder.build(this.getPlugin(), new Dom4jNode(this.descriptor)));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

