/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module;

import com.atlassian.plugin.remotable.plugin.util.EncodingUtils;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.google.common.collect.Maps;
import java.util.Map;

public final class IFrameParamsImpl
implements IFrameParams {
    private final Map<String, Object> params = Maps.newHashMap();

    public IFrameParamsImpl(Node module) {
        this.addToParams(module, "height");
        this.addToParams(module, "width");
    }

    public void addToParams(Node e, String key) {
        Node val = e.get(key);
        if (val.exists()) {
            this.params.put(key, EncodingUtils.escapeQuotes(val.asString()));
        }
    }

    public void setParam(String key, String value) {
        this.params.put(key, EncodingUtils.escapeQuotes(value));
    }

    public void setParamNoEscape(String key, String value) {
        this.params.put(key, value);
    }

    public Map<String, Object> getAsMap() {
        return this.params;
    }
}

