/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.remotable.spi.module.UserIsLoggedInCondition;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConditionLoadingPlugin
extends AbstractDelegatingPlugin
implements AutowireCapablePlugin {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AutowireCapablePlugin remotablePlugin;
    private final Set<Class<?>> productConditions;

    public ConditionLoadingPlugin(AutowireCapablePlugin remotablePlugin, Plugin delegate, Set<Class<?>> productConditions) {
        super(delegate);
        this.remotablePlugin = remotablePlugin;
        this.productConditions = productConditions;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return super.loadClass(clazz, callingClass);
        }
        catch (ClassNotFoundException ex) {
            return this.cast(((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz));
        }
    }

    public <T> T autowire(Class<T> clazz) throws UnsupportedOperationException {
        if (this.isRemotablePluginCondition(clazz)) {
            return (T)this.remotablePlugin.autowire(clazz);
        }
        return (T)this.getAutowireCapableDelegate().autowire(clazz);
    }

    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws UnsupportedOperationException {
        if (this.isRemotablePluginCondition(clazz)) {
            return (T)this.remotablePlugin.autowire(clazz, autowireStrategy);
        }
        return (T)this.getAutowireCapableDelegate().autowire(clazz, autowireStrategy);
    }

    public void autowire(Object instance) {
        this.getAutowireCapableDelegate().autowire(instance);
    }

    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) {
        this.getAutowireCapableDelegate().autowire(instance, autowireStrategy);
    }

    private <T> boolean isRemotablePluginCondition(Class<T> clazz) {
        return this.isInRemotablePluginConditionsPackage(clazz) || this.productConditions.contains(clazz);
    }

    private <T> boolean isInRemotablePluginConditionsPackage(Class clazz) {
        Package remotablePluginConditionPackage;
        Package clazzPackage = clazz.getPackage();
        boolean isRemotablePluginConditionPackage = clazzPackage.equals(remotablePluginConditionPackage = UserIsLoggedInCondition.class.getPackage());
        if (!isRemotablePluginConditionPackage && clazzPackage.getName().equals(remotablePluginConditionPackage.getName())) {
            this.logger.warn("Class '{}' package is not equal to '{}'. Yet they have the same name. This is probably not what you expected, as it means those were not loaded by the same classloader. For you information the class was loaded from classloader: {} while the package is from classloader: {}", new Object[]{clazz.getName(), remotablePluginConditionPackage.getName(), clazz.getClassLoader(), UserIsLoggedInCondition.class.getClassLoader()});
        }
        return isRemotablePluginConditionPackage;
    }

    private AutowireCapablePlugin getAutowireCapableDelegate() {
        return (AutowireCapablePlugin)this.getDelegate();
    }

    private <T> Class<T> cast(Class<?> aClass) {
        return aClass;
    }
}

