/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.installer;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.remotable.plugin.util.zip.ZipBuilder;
import com.atlassian.plugin.remotable.plugin.util.zip.ZipHandler;
import java.io.IOException;
import java.net.URI;
import org.dom4j.Document;
import org.springframework.stereotype.Component;

@Component
public class RemotePluginArtifactFactory {
    public PluginArtifact create(URI registrationUrl, final Document document, String username) {
        String pluginKey = document.getRootElement().attributeValue("key");
        this.changeDescriptorToIncludeRemotePluginHeader(document, registrationUrl, username);
        return new JarPluginArtifact(ZipBuilder.buildZip("install-" + pluginKey, new ZipHandler(){

            @Override
            public void build(ZipBuilder builder) throws IOException {
                builder.addFile("atlassian-plugin.xml", document);
            }
        }));
    }

    private void changeDescriptorToIncludeRemotePluginHeader(Document document, URI registrationUrl, String username) {
        document.getRootElement().element("plugin-info").addElement("bundle-instructions").addElement("Remote-Plugin").addText("installer;user=\"" + username + "\";date=\"" + System.currentTimeMillis() + "\"" + ";registration-url=\"" + registrationUrl + "\"");
    }
}

