/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.remotable.plugin.module.applinks.RemotePluginContainerModuleDescriptor;
import com.atlassian.plugin.remotable.spi.event.RemotePluginDisabledEvent;
import com.atlassian.plugin.remotable.spi.event.RemotePluginEnabledEvent;
import com.atlassian.plugin.remotable.spi.event.RemotePluginInstalledEvent;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.security.Key;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RemoteEventsHandler
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final PluginEventManager pluginEventManager;
    private final ConsumerService consumerService;
    private final ApplicationProperties applicationProperties;
    private final ProductAccessor productAccessor;
    private final BundleContext bundleContext;

    @Autowired
    public RemoteEventsHandler(EventPublisher eventPublisher, ConsumerService consumerService, ApplicationProperties applicationProperties, ProductAccessor productAccessor, BundleContext bundleContext, PluginEventManager pluginEventManager) {
        this.consumerService = (ConsumerService)Preconditions.checkNotNull((Object)consumerService);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.productAccessor = (ProductAccessor)Preconditions.checkNotNull((Object)productAccessor);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
    }

    public void pluginInstalled(String pluginKey) {
        this.eventPublisher.publish((Object)new RemotePluginInstalledEvent((String)Preconditions.checkNotNull((Object)pluginKey), this.newRemotePluginEventData()));
    }

    @PluginEventListener
    public void pluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        Plugin plugin = pluginEnabledEvent.getPlugin();
        if (this.isRemotablePlugin(plugin)) {
            this.eventPublisher.publish((Object)new RemotePluginEnabledEvent(plugin.getKey(), this.newRemotePluginEventData()));
        }
    }

    @PluginEventListener
    public void pluginDisabled(PluginDisabledEvent pluginDisabledEvent) {
        Plugin plugin = pluginDisabledEvent.getPlugin();
        if (this.isRemotablePlugin(plugin)) {
            this.eventPublisher.publish((Object)new RemotePluginDisabledEvent(plugin.getKey(), this.newRemotePluginEventData()));
        }
    }

    private boolean isRemotablePlugin(Plugin plugin) {
        return Iterables.any((Iterable)plugin.getModuleDescriptors(), (Predicate)new Predicate<ModuleDescriptor<?>>(){

            public boolean apply(ModuleDescriptor<?> moduleDescriptor) {
                return moduleDescriptor instanceof RemotePluginContainerModuleDescriptor;
            }
        });
    }

    @VisibleForTesting
    Map<String, Object> newRemotePluginEventData() {
        Consumer consumer = this.consumerService.getConsumer();
        return ImmutableMap.builder().put((Object)"links", (Object)ImmutableMap.of((Object)"oauth", (Object)(this.applicationProperties.getBaseUrl() + "/rest/remotable-plugins/latest/oauth"))).put((Object)"clientKey", (Object)Strings.nullToEmpty((String)consumer.getKey())).put((Object)"publicKey", (Object)Strings.nullToEmpty((String)RSAKeys.toPemEncoding((Key)consumer.getPublicKey()))).put((Object)"serverVersion", (Object)Strings.nullToEmpty((String)this.applicationProperties.getBuildNumber())).put((Object)"pluginsVersion", (Object)Strings.nullToEmpty((String)this.getRemotablePluginsPluginVersion())).put((Object)"baseUrl", (Object)Strings.nullToEmpty((String)this.applicationProperties.getBaseUrl())).put((Object)"productType", (Object)Strings.nullToEmpty((String)this.productAccessor.getKey())).put((Object)"description", (Object)Strings.nullToEmpty((String)consumer.getDescription())).build();
    }

    private String getRemotablePluginsPluginVersion() {
        Object bundleVersion = this.bundleContext.getBundle().getHeaders().get("Bundle-Version");
        return bundleVersion == null ? null : bundleVersion.toString();
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }
}

