/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.webhooks;

import com.atlassian.plugin.remotable.spi.event.RemotePluginDisabledEvent;
import com.atlassian.plugin.remotable.spi.event.RemotePluginEnabledEvent;
import com.atlassian.plugin.remotable.spi.event.RemotePluginEvent;
import com.atlassian.plugin.remotable.spi.event.RemotePluginInstalledEvent;
import com.atlassian.webhooks.spi.provider.ConsumerKey;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.EventSerializers;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;
import com.google.common.base.Preconditions;
import java.util.Map;

public final class PluginsWebHookProvider
implements WebHookProvider {
    public static final String REMOTE_PLUGIN_INSTALLED = "remote_plugin_installed";
    public static final String REMOTE_PLUGIN_ENABLED = "remote_plugin_enabled";
    public static final String REMOTE_PLUGIN_DISABLED = "remote_plugin_disabled";

    public void provide(WebHookRegistrar registrar) {
        RemotePluginEventSerializerFactory serializerFactory = new RemotePluginEventSerializerFactory();
        RemotePluginEventMatcher eventTypeMatcher = new RemotePluginEventMatcher();
        registrar.webhook(REMOTE_PLUGIN_INSTALLED).whenFired(RemotePluginInstalledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
        registrar.webhook(REMOTE_PLUGIN_ENABLED).whenFired(RemotePluginEnabledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
        registrar.webhook(REMOTE_PLUGIN_DISABLED).whenFired(RemotePluginDisabledEvent.class).matchedBy(eventTypeMatcher).serializedWith(serializerFactory);
    }

    private static final class RemotePluginEventSerializerFactory<E extends RemotePluginEvent>
    implements EventSerializerFactory<E> {
        private RemotePluginEventSerializerFactory() {
        }

        public EventSerializer create(E event) {
            return EventSerializers.forMap(event, (Map)event.toMap());
        }
    }

    private static final class RemotePluginEventMatcher<E extends RemotePluginEvent>
    implements EventMatcher<E> {
        private RemotePluginEventMatcher() {
        }

        public boolean matches(E event, ConsumerKey consumerKey) {
            return ((String)Preconditions.checkNotNull((Object)((ConsumerKey)Preconditions.checkNotNull((Object)consumerKey)).getPluginKey())).equals(event.getPluginKey());
        }
    }
}

