/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.service;

import com.atlassian.oauth.Request;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.host.common.service.AbstractOauthSignedRequestHandler;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBDispatchFilter;
import com.atlassian.plugin.remotable.plugin.util.OAuthHelper;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import net.oauth.OAuthMessage;

public class LocalSignedRequestHandler
extends AbstractOauthSignedRequestHandler
implements SignedRequestHandler {
    private final UBDispatchFilter ubDispatchFilter;
    private final ApplicationProperties applicationProperties;
    private final ConsumerService consumerService;
    private final String pluginKey;

    public LocalSignedRequestHandler(UBDispatchFilter ubDispatchFilter, ApplicationProperties applicationProperties, ConsumerService consumerService, String pluginKey) {
        this.ubDispatchFilter = ubDispatchFilter;
        this.applicationProperties = applicationProperties;
        this.consumerService = consumerService;
        this.pluginKey = pluginKey;
    }

    @Override
    public String getHostBaseUrl(String key) {
        return this.applicationProperties.getBaseUrl();
    }

    @Override
    public String getAuthorizationHeaderValue(URI uri, String method, String username) throws IllegalArgumentException {
        ImmutableSet params = username != null ? ImmutableSet.of((Object)new Request.Parameter("user_id", username)) : Collections.emptySet();
        Request request = new Request(Request.HttpMethod.valueOf((String)method), uri, (Iterable)params);
        URI dummyUri = URI.create("http://localhost");
        OAuthMessage message = OAuthHelper.asOAuthMessage(this.consumerService.sign(request, new ServiceProvider(dummyUri, dummyUri, dummyUri)));
        try {
            return message.getAuthorizationHeader(this.pluginKey);
        }
        catch (IOException e) {
            throw new IllegalStateException("shouldn't happen", e);
        }
    }

    @Override
    public String getLocalBaseUrl() {
        return this.ubDispatchFilter.getLocalMountBaseUrl(this.pluginKey);
    }

    @Override
    protected Object getHostOauthPublicKey(String key) {
        return this.consumerService.getConsumer().getPublicKey().getEncoded();
    }
}

