/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.remotable.plugin.module.ConditionProcessor;
import com.atlassian.plugin.remotable.plugin.module.ContainingRemoteCondition;
import com.atlassian.plugin.remotable.plugin.module.util.redirect.RedirectServlet;
import com.atlassian.plugin.remotable.spi.module.DynamicMarkerCondition;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class WebItemCreator {
    private final ProductAccessor productAccessor;
    private final ConditionProcessor conditionProcessor;
    private static final Logger log = LoggerFactory.getLogger(WebItemCreator.class);

    @Autowired
    public WebItemCreator(ProductAccessor productAccessor, ConditionProcessor conditionProcessor) {
        this.productAccessor = productAccessor;
        this.conditionProcessor = conditionProcessor;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public class Builder {
        private Class<? extends Condition> condition = AlwaysDisplayCondition.class;
        private String additionalStyleClass = "";
        private Map<String, String> contextParams;
        private int preferredWeight;
        private String preferredSectionKey;

        public WebItemModuleDescriptor build(Plugin plugin, String key, URI localUrl, Element configurationElement) {
            Condition condition;
            Validate.notNull(this.condition);
            Validate.notNull((Object)key);
            Validate.notNull((Object)configurationElement);
            Element config = configurationElement.createCopy();
            config.elements("conditions").clear();
            String webItemKey = "webitem-" + key;
            config.addAttribute("key", webItemKey);
            config.addAttribute("section", Dom4jUtils.getOptionalAttribute((Element)configurationElement, (String)"section", (Object)this.preferredSectionKey));
            config.addAttribute("weight", Dom4jUtils.getOptionalAttribute((Element)configurationElement, (String)"weight", (Object)this.preferredWeight));
            String name = Dom4jUtils.getOptionalAttribute((Element)configurationElement, (String)"link-name", (Object)StringEscapeUtils.escapeHtml((String)Dom4jUtils.getRequiredAttribute((Element)configurationElement, (String)"name")));
            config.addElement("label").addAttribute("key", name);
            Element linkElement = config.addElement("link").addAttribute("linkId", webItemKey);
            if (localUrl != null) {
                String url;
                String height;
                if (localUrl.toString().contains("$")) {
                    throw new PluginParseException("Invalid url '" + localUrl + "', cannot contain velocity expressions");
                }
                UriBuilder uriBuilder = new UriBuilder(Uri.parse("/plugins/servlet" + localUrl));
                String width = Dom4jUtils.getOptionalAttribute((Element)configurationElement, (String)"width", null);
                if (width != null) {
                    uriBuilder.addQueryParameter("width", width);
                }
                if ((height = Dom4jUtils.getOptionalAttribute((Element)configurationElement, (String)"height", null)) != null) {
                    uriBuilder.addQueryParameter("height", height);
                }
                String sep = (url = uriBuilder.toString()).indexOf("?") > 0 ? "&" : "?";
                for (Map.Entry<String, String> entry : this.contextParams.entrySet()) {
                    url = url + sep + entry.getKey() + "=" + entry.getValue();
                    sep = "&";
                }
                linkElement.setText(url);
            }
            if (!StringUtils.isBlank((String)this.additionalStyleClass)) {
                config.addElement("styleClass").setText(this.additionalStyleClass);
            }
            this.convertIcon(plugin, configurationElement, config);
            config.addElement("condition").addAttribute("class", DynamicMarkerCondition.class.getName());
            if (this.condition != null) {
                config.addElement("condition").addAttribute("class", this.condition.getName());
            }
            if ((condition = WebItemCreator.this.conditionProcessor.process(configurationElement, config, plugin.getKey())) instanceof ContainingRemoteCondition) {
                Element styleClass = config.element("styleClass");
                if (styleClass == null) {
                    styleClass = config.addElement("styleClass");
                } else {
                    styleClass.addText(" ");
                }
                styleClass.addText("remote-condition hidden " + WebItemCreator.this.conditionProcessor.createUniqueUrlHash(plugin.getKey(), ((ContainingRemoteCondition)condition).getConditionUrl()));
            }
            if (log.isDebugEnabled()) {
                log.debug("Created web item: " + Dom4jUtils.printNode((Node)config));
            }
            return this.createWebItemDescriptor(WebItemCreator.this.conditionProcessor.getLoadablePlugin(plugin), config);
        }

        private WebItemModuleDescriptor createWebItemDescriptor(Plugin plugin, Element config) {
            config.addAttribute("system", "true");
            WebItemModuleDescriptor descriptor = WebItemCreator.this.productAccessor.createWebItemModuleDescriptor();
            descriptor.init(plugin, config);
            return descriptor;
        }

        private void convertIcon(Plugin plugin, Element source, Element target) {
            URI iconUri = Dom4jUtils.getOptionalUriAttribute((Element)source, (String)"icon-url");
            if (iconUri != null) {
                target.addElement("icon").addAttribute("width", "16").addAttribute("height", "16").addElement("link").addText(RedirectServlet.getPermanentRedirectUrl(plugin.getKey(), iconUri));
            }
        }

        public Builder setCondition(Class<? extends Condition> condition) {
            this.condition = condition;
            return this;
        }

        public Builder setAdditionalStyleClass(String additionalStyleClass) {
            this.additionalStyleClass = additionalStyleClass;
            return this;
        }

        public Builder setContextParams(Map<String, String> contextParams) {
            this.contextParams = contextParams;
            return this;
        }

        public Builder setPreferredWeight(int preferredWeight) {
            this.preferredWeight = preferredWeight;
            return this;
        }

        public Builder setPreferredSectionKey(String preferredSectionKey) {
            this.preferredSectionKey = preferredSectionKey;
            return this;
        }
    }
}

