/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidatorProvider;
import com.atlassian.plugin.remotable.plugin.descriptor.InputStreamSupplierLSInput;
import com.atlassian.plugin.remotable.plugin.descriptor.PluginDescriptorValidatorProvider;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.schema.spi.SchemaDocumented;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component
public final class DescriptorValidator {
    private final Plugin plugin;
    private final ProductAccessor productAccessor;
    private final WebResourceManager webResourceManager;
    private final PermissionManager permissionManager;
    private final DescriptorValidatorProvider pluginDescriptorValidatorProvider;

    @Autowired
    public DescriptorValidator(PluginRetrievalService pluginRetrievalService, ProductAccessor productAccessor, WebResourceManager webResourceManager, PermissionManager permissionManager, PluginDescriptorValidatorProvider pluginDescriptorValidatorProvider) {
        this.productAccessor = productAccessor;
        this.webResourceManager = webResourceManager;
        this.permissionManager = permissionManager;
        this.plugin = pluginRetrievalService.getPlugin();
        this.pluginDescriptorValidatorProvider = pluginDescriptorValidatorProvider;
    }

    public void validate(URI url, Document document) {
        InstallationMode installationMode = InstallationMode.LOCAL;
        boolean useNamespace = document.getRootElement().getNamespaceURI().equals(this.pluginDescriptorValidatorProvider.getSchemaNamespace(installationMode));
        String builtSchema = this.buildSchema(this.pluginDescriptorValidatorProvider, useNamespace, installationMode);
        try {
            Schema schema = DescriptorValidator.getSchema((InputSupplier<? extends Reader>)CharStreams.newReaderSupplier((String)builtSchema), new PluginLSResourceResolver(this.plugin));
            Validator validator = schema.newValidator();
            DocumentSource source = new DocumentSource(document);
            source.setSystemId(url.toString());
            validator.validate((Source)source);
        }
        catch (SAXException e) {
            throw new InstallationFailedException("Unable to parse the descriptor: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pluginDescriptorValidatorProvider.performSecondaryValidations(document);
    }

    static Schema getSchema(InputSupplier<? extends Reader> schemaInput, LSResourceResolver resourceResolver) throws IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Reader schemaReader = null;
        try {
            schemaReader = (Reader)schemaInput.getInput();
            schemaFactory.setResourceResolver(resourceResolver);
            Schema schema = schemaFactory.newSchema(new StreamSource(schemaReader));
            return schema;
        }
        catch (SAXParseException e) {
            throw new RuntimeException(String.format("Couldn't parse schema (line %s, column %s):\n%s", e.getLineNumber(), e.getColumnNumber(), CharStreams.toString(schemaInput)), e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Couldn't parse schema:\n" + CharStreams.toString(schemaInput), e);
        }
        finally {
            Closeables.closeQuietly((Closeable)schemaReader);
        }
    }

    public String getPluginSchema(InstallationMode installationMode) {
        try {
            return this.buildSchema(this.pluginDescriptorValidatorProvider, true, installationMode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String buildSchema(DescriptorValidatorProvider descriptorValidatorProvider, boolean usesNamespace, InstallationMode installationMode) {
        return this.buildSchema(Dom4jUtils.parseDocument((URL)descriptorValidatorProvider.getSchemaUrl()), descriptorValidatorProvider, usesNamespace, installationMode);
    }

    private String buildSchema(Document schema, DescriptorValidatorProvider descriptorValidatorProvider, boolean usesNamespace, InstallationMode installationMode) {
        DescriptorValidator.addNamespace(schema, descriptorValidatorProvider, usesNamespace, installationMode);
        HashSet includedDocIds = Sets.newHashSet();
        this.processIncludes(schema, includedDocIds);
        this.addModules(schema, descriptorValidatorProvider, installationMode, includedDocIds);
        DescriptorValidator.addPermissions(schema, this.permissionManager.getPermissions(installationMode));
        this.addXslStyleSheet(schema);
        return Dom4jUtils.printNode((Node)schema);
    }

    private void addModules(Document schema, DescriptorValidatorProvider descriptorValidatorProvider, InstallationMode installationMode, Set<String> includedDocIds) {
        Element choiceOfModules = DescriptorValidator.selectSingleNode((Node)schema, "/xs:schema/xs:complexType[@name='%s']//xs:choice", descriptorValidatorProvider.getRootElementName());
        for (com.atlassian.plugin.schema.spi.Schema moduleSchema : descriptorValidatorProvider.getModuleSchemas(installationMode)) {
            this.addModule(choiceOfModules, moduleSchema, includedDocIds);
        }
    }

    private void addModule(Element choiceOfModules, com.atlassian.plugin.schema.spi.Schema moduleSchema, Set<String> includedDocIds) {
        String id = moduleSchema.getFileName();
        if (!includedDocIds.contains(id)) {
            includedDocIds.add(id);
            Document moduleSchemaDocument = moduleSchema.getDocument();
            Preconditions.checkNotNull((Object)moduleSchemaDocument, (Object)("Document from generator " + moduleSchema.getFileName() + " is null"));
            this.processIncludes(moduleSchemaDocument, includedDocIds);
            this.addModuleSchemaElementsToSchema(choiceOfModules, moduleSchemaDocument);
        }
        Element module = this.addModuleElementToSchema(choiceOfModules, moduleSchema);
        Element moduleDocumentation = DescriptorValidator.addSchemaDocumentation(module, (SchemaDocumented)moduleSchema);
        DescriptorValidator.addPermissionDocumentation(moduleDocumentation, moduleSchema);
    }

    @VisibleForTesting
    static void addPermissionDocumentation(Element moduleDocumentation, com.atlassian.plugin.schema.spi.Schema moduleSchema) {
        DescriptorValidator.addPermissionDocumentation(moduleDocumentation, "required-permissions", moduleSchema.getRequiredPermissions());
        DescriptorValidator.addPermissionDocumentation(moduleDocumentation, "optional-permissions", moduleSchema.getOptionalPermissions());
    }

    private static void addPermissionDocumentation(Element moduleDocumentation, String permissionsElementName, Iterable<String> permissions) {
        if (Iterables.isEmpty(permissions)) {
            return;
        }
        Element permissionsElement = moduleDocumentation.addElement(permissionsElementName);
        for (String permission : permissions) {
            permissionsElement.addElement("permission").setText(permission);
        }
    }

    private void addModuleSchemaElementsToSchema(Element choiceOfModules, Document doc) {
        for (Element child : doc.getRootElement().elements()) {
            choiceOfModules.getDocument().getRootElement().elements().add(0, child.detach());
        }
    }

    private Element addModuleElementToSchema(Element choiceOfModules, com.atlassian.plugin.schema.spi.Schema moduleSchema) {
        return choiceOfModules.addElement("xs:element").addAttribute("name", moduleSchema.getElementName()).addAttribute("type", moduleSchema.getComplexType()).addAttribute("maxOccurs", moduleSchema.getMaxOccurs());
    }

    private static Element selectSingleNode(final Node node, String xpath, String ... args) {
        String actualXpath = String.format(xpath, args);
        Element element = (Element)node.selectSingleNode(actualXpath);
        Preconditions.checkState((element != null ? 1 : 0) != 0, (String)"Could not find single node for xpath '%s' in:\n%s\n", (Object[])new Object[]{actualXpath, LazyToString.of(new Supplier<String>(){

            public String get() {
                return Dom4jUtils.printNode((Node)node);
            }
        })});
        return element;
    }

    private static void addPermissions(Document schema, Iterable<Permission> permissions) {
        Element permissionsType = DescriptorValidator.selectSingleNode((Node)schema, "/xs:schema/xs:simpleType[@name='PermissionValueType']/xs:restriction", new String[0]);
        for (Permission permission : permissions) {
            DescriptorValidator.addPermission(permissionsType, permission);
        }
    }

    private static void addPermission(Element permissionsType, Permission permission) {
        Element enumeration = permissionsType.addElement("xs:enumeration").addAttribute("value", permission.getKey());
        Element doc = DescriptorValidator.addSchemaDocumentation(enumeration, (SchemaDocumented)permission);
        if (permission instanceof ApiScope) {
            DescriptorValidator.addApiScopeResourcesInformation(doc, (ApiScope)permission);
        }
    }

    private static void addApiScopeResourcesInformation(Element doc, ApiScope apiScope) {
        Element resources = doc.addElement("resources");
        for (ApiResourceInfo resource : apiScope.getApiResourceInfos()) {
            DescriptorValidator.addApiScopeResourceInformation(resources, resource);
        }
    }

    private static void addApiScopeResourceInformation(Element resources, ApiResourceInfo resource) {
        Element res = resources.addElement("resource").addAttribute("path", resource.getPath()).addAttribute("httpMethod", resource.getHttpMethod());
        if (resource.getRpcMethod() != null) {
            res.addAttribute("rpcMethod", resource.getRpcMethod());
        }
    }

    public static Element addSchemaDocumentation(Element source, SchemaDocumented generator) {
        Element desc;
        Element doc = DescriptorValidator.getOrAddElementsIfDoNotExist(source, "xs:annotation", "xs:documentation");
        Element name = DescriptorValidator.getOrAddElementIfDoesNotExist(doc, "name");
        if (StringUtils.isBlank((String)name.getText()) && generator.getName() != null) {
            name.setText(generator.getName());
        }
        if (StringUtils.isBlank((String)(desc = DescriptorValidator.getOrAddElementIfDoesNotExist(doc, "description")).getText()) && generator.getDescription() != null) {
            desc.setText(generator.getDescription());
        }
        return doc;
    }

    private static Element getOrAddElementsIfDoNotExist(Element source, String ... names) {
        Element el = source;
        for (String name : names) {
            el = DescriptorValidator.getOrAddElementIfDoesNotExist(el, name);
        }
        return el;
    }

    private static Element getOrAddElementIfDoesNotExist(Element source, String name) {
        Element el = source.element(name);
        if (el == null) {
            el = source.addElement(name);
        }
        return el;
    }

    private static void addNamespace(Document schema, DescriptorValidatorProvider descriptorValidatorProvider, boolean usesNamespace, InstallationMode installationMode) {
        if (usesNamespace) {
            String ns = descriptorValidatorProvider.getSchemaNamespace(installationMode);
            Element root = schema.getRootElement();
            root.addAttribute("targetNamespace", ns);
            root.addAttribute("xmlns", ns);
        }
    }

    private void addXslStyleSheet(Document schema) {
        HashMap arguments = Maps.newHashMap();
        arguments.put("type", "text/xsl");
        arguments.put("href", this.getXslStyleSheetUrl());
        schema.content().add(0, new DocumentFactory().createProcessingInstruction("xml-stylesheet", (Map)arguments));
    }

    private String getXslStyleSheetUrl() {
        return this.webResourceManager.getStaticPluginResource("com.atlassian.labs.remoteapps-plugin:schema-xsl", "xs3p.xsl", UrlMode.ABSOLUTE);
    }

    private void processIncludes(Document doc, Set<String> includedDocIds) {
        Element root = doc.getRootElement();
        List rootIncludes = root.elements("include");
        for (Element include : rootIncludes) {
            int pos = include.getParent().elements().indexOf(include);
            include.detach();
            String schemaLocation = include.attributeValue("schemaLocation");
            if (includedDocIds.contains(schemaLocation)) continue;
            URL resource = this.plugin.getResource("/xsd/" + schemaLocation);
            if (resource == null) {
                throw new IllegalArgumentException("Can't find resource: " + schemaLocation);
            }
            Document includeDoc = Dom4jUtils.parseDocument((URL)resource);
            this.processIncludes(includeDoc, includedDocIds);
            if (schemaLocation.equals("common.xsd")) {
                this.insertAvailableLinkContextParams(includeDoc, this.productAccessor.getLinkContextParams());
                this.insertAvailableWebConditions(includeDoc, this.productAccessor.getConditions());
            }
            List includeChildren = includeDoc.getRootElement().elements();
            Collections.reverse(includeChildren);
            for (Element child : includeChildren) {
                if (!root.elements().isEmpty()) {
                    root.elements().add(pos, child.detach());
                    continue;
                }
                root.add(child.detach());
            }
            includedDocIds.add(schemaLocation);
        }
    }

    private void insertAvailableLinkContextParams(Document includeDoc, Map<String, String> linkContextParams) {
        Element restriction = (Element)includeDoc.selectSingleNode("/xs:schema/xs:simpleType[@name='LinkContextParameterNameType']/xs:restriction");
        if (restriction != null) {
            for (Map.Entry<String, String> entry : linkContextParams.entrySet()) {
                String name = entry.getKey();
                restriction.addElement("xs:enumeration").addAttribute("value", name);
            }
        }
    }

    private void insertAvailableWebConditions(Document includeDoc, Map<String, Class<? extends Condition>> webConditions) {
        Element restriction = (Element)includeDoc.selectSingleNode("/xs:schema/xs:simpleType[@name='ConditionNameType']/xs:restriction");
        if (restriction != null) {
            for (String name : webConditions.keySet()) {
                restriction.addElement("xs:enumeration").addAttribute("value", name);
            }
        }
    }

    private static final class LazyToString<T> {
        private final Supplier<T> supplier;

        private LazyToString(Supplier<T> supplier) {
            this.supplier = (Supplier)Preconditions.checkNotNull(supplier);
        }

        static <T> LazyToString<T> of(Supplier<T> s) {
            return new LazyToString<T>(s);
        }

        public String toString() {
            return this.supplier.get().toString();
        }
    }

    private static class PluginLSResourceResolver
    implements LSResourceResolver {
        private final Plugin plugin;

        private PluginLSResourceResolver(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            final String resource = systemId;
            InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return PluginLSResourceResolver.this.plugin.getResourceAsStream("/xsd/" + resource);
                }
            };
            return new InputStreamSupplierLSInput(systemId, publicId, inputSupplier);
        }
    }
}

