/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.ConsumableBigPipe;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.DefaultBigPipeManager;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigPipeContentFilter
implements Filter {
    private static final Pattern URI_PATTERN = Pattern.compile("/bigpipe/request/([0-9a-fA-F]+)(/[0-9]+)?$");
    private static final Logger log = LoggerFactory.getLogger(BigPipeContentFilter.class);
    private final DefaultBigPipeManager bigPipeManager;

    public BigPipeContentFilter(DefaultBigPipeManager bigPipeManager) {
        this.bigPipeManager = (DefaultBigPipeManager)Preconditions.checkNotNull((Object)bigPipeManager);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sres;
        String uri = req.getRequestURI();
        log.debug("Incoming big pipe content request on {}", (Object)Thread.currentThread().getId());
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (matcher.find()) {
            String requestId = matcher.group(1);
            Option<ConsumableBigPipe> bigPipeOption = this.bigPipeManager.getConsumableBigPipe(requestId);
            if (!bigPipeOption.isEmpty()) {
                res.setStatus(200);
                res.setContentType("application/json");
                res.setCharacterEncoding("UTF-8");
                res.setHeader("Cache-Control", "no-cache");
                String result = ((ConsumableBigPipe)bigPipeOption.get()).waitForContent();
                res.getWriter().write(result);
            } else {
                log.warn("Big pipe is empty, returning 404 on {}", (Object)Thread.currentThread().getId());
                res.sendError(404);
            }
        } else {
            log.warn("ID pattern not matched for big pipe content request on {}", (Object)Thread.currentThread().getId());
            res.sendError(404);
        }
        log.debug("Big pipe content request sent on {}", (Object)Thread.currentThread().getId());
    }

    public void destroy() {
    }
}

