/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.integration.plugins;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.plugin.integration.plugins.I18nModuleDescriptor;
import com.atlassian.plugin.remotable.plugin.loader.StartableForPlugins;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dom4j.DocumentHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class I18nPropertiesPluginManager {
    private static final Logger log = LoggerFactory.getLogger(I18nPropertiesPluginManager.class);
    public static final String I18N_SYMBOLIC_NAME = "remotable.plugins.i18n";
    private final ModuleFactory moduleFactory;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final BundleContext bundleContext;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, String> i18nToRegister = CopyOnWriteMap.newHashMap();
    private volatile Bundle i18nBundle;

    @Autowired
    public I18nPropertiesPluginManager(ModuleFactory moduleFactory, PluginAccessor accessor, PluginController pluginController, BundleContext bundleContext, StartableForPlugins startableForPlugins, PluginRetrievalService pluginRetrievalService) {
        this.moduleFactory = (ModuleFactory)Preconditions.checkNotNull((Object)moduleFactory);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)accessor);
        this.pluginController = (PluginController)Preconditions.checkNotNull((Object)pluginController);
        startableForPlugins.register(pluginRetrievalService.getPlugin().getKey(), new Runnable(){

            @Override
            public void run() {
                I18nPropertiesPluginManager.this.loadBundle();
                I18nPropertiesPluginManager.this.registerI18n(I18nPropertiesPluginManager.this.i18nToRegister);
                I18nPropertiesPluginManager.this.started.set(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forBundle(Bundle bundle, BundleManipulator manip) {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(bout);
            Enumeration files = bundle.findEntries("/", "*.properties", false);
            if (files != null) {
                while (files.hasMoreElements()) {
                    URL url = (URL)files.nextElement();
                    String name = url.getFile();
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if (!manip.includeEntry(name)) continue;
                    zout.putNextEntry(new ZipEntry(name));
                    IOUtils.copy((InputStream)url.openStream(), (OutputStream)zout);
                }
            }
            manip.finish(bundle, zout);
            Manifest mf = new Manifest(bundle.getEntry("META-INF/MANIFEST.MF").openStream());
            zout.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            mf.write(zout);
            zout.close();
            File tmpFile = File.createTempFile(I18N_SYMBOLIC_NAME, ".jar");
            FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])bout.toByteArray());
            this.pluginController.installPlugins(new PluginArtifact[]{new JarPluginArtifact(tmpFile)});
            tmpFile.delete();
            this.setI18nBundle();
        }
        catch (IOException e) {
            log.warn("Unable to save i18n files", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bout);
        }
    }

    public synchronized String add(String pluginKey, Properties i18nProperties) {
        StringWriter writer = new StringWriter();
        try {
            i18nProperties.store(writer, pluginKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String data = writer.toString();
        String name = String.valueOf(Math.abs(writer.toString().hashCode()));
        this.i18nToRegister.put(name, data);
        if (this.started.get()) {
            this.registerI18n(this.i18nToRegister);
        }
        return name;
    }

    private synchronized void registerI18n(final Map<String, String> i18n) {
        this.forBundle(this.i18nBundle, new BundleManipulator(){

            @Override
            public boolean includeEntry(String entryName) {
                return !i18n.keySet().contains(entryName.substring(0, entryName.length() - ".properties".length()));
            }

            @Override
            public void finish(Bundle bundle, ZipOutputStream zout) throws IOException {
                for (Map.Entry entry : i18n.entrySet()) {
                    zout.putNextEntry(new ZipEntry((String)entry.getKey() + ".properties"));
                    IOUtils.copy((Reader)new StringReader((String)entry.getValue()), (OutputStream)zout, (String)"UTF-8");
                }
            }
        });
        for (String name : i18n.keySet()) {
            I18nModuleDescriptor descriptor = new I18nModuleDescriptor(this.moduleFactory);
            descriptor.init(this.findI18nPlugin(), DocumentHelper.createElement((String)"i18n-something").addAttribute("key", name).addAttribute("system", "true").addElement("resource").addAttribute("type", "i18n").addAttribute("name", "i18n").addAttribute("location", name).getParent());
            this.i18nBundle.getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)descriptor, null);
        }
    }

    private void loadBundle() {
        if (this.findI18nPlugin() == null) {
            this.createAndInstallI18nPlugin();
        }
        this.ensureI18nPluginIsEnabled();
        this.setI18nBundle();
    }

    private Plugin findI18nPlugin() {
        return this.pluginAccessor.getPlugin(I18N_SYMBOLIC_NAME);
    }

    private Plugin createAndInstallI18nPlugin() {
        File i18nPluginTempFile = this.createI18nPluginTempFile();
        this.pluginController.installPlugins(new PluginArtifact[]{new JarPluginArtifact(i18nPluginTempFile)});
        if (!i18nPluginTempFile.delete()) {
            log.warn("Could not delete i18n temp file at '{}'", (Object)i18nPluginTempFile);
        }
        return this.findI18nPlugin();
    }

    private File createI18nPluginTempFile() {
        try {
            File tmpFile = File.createTempFile(I18N_SYMBOLIC_NAME, ".jar");
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmpFile));
            this.addManifest(zout);
            zout.close();
            return tmpFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create remotable.plugins.i18n plugin temp jar file.", e);
        }
    }

    private void addManifest(ZipOutputStream zout) throws IOException {
        zout.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        Manifest mf = this.createI18nPluginManifest();
        mf.write(zout);
    }

    private Manifest createI18nPluginManifest() {
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1");
        mf.getMainAttributes().putValue("Bundle-SymbolicName", I18N_SYMBOLIC_NAME);
        mf.getMainAttributes().putValue("Atlassian-Plugin-Key", I18N_SYMBOLIC_NAME);
        mf.getMainAttributes().putValue("Bundle-Version", "1");
        mf.getMainAttributes().putValue("Bundle-Description", "I18n properties files for remote plugins");
        mf.getMainAttributes().putValue("Bundle-Name", "Remotable Plugins I18n plugin");
        mf.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        mf.getMainAttributes().putValue("Spring-Context", "*");
        mf.getMainAttributes().putValue("Import-Package", "com.atlassian.plugin.remotable.api");
        return mf;
    }

    private void setI18nBundle() {
        this.i18nBundle = BundleUtil.findBundleWithName(this.bundleContext, I18N_SYMBOLIC_NAME);
        if (this.i18nBundle == null) {
            throw new IllegalStateException("The i18n bundle (remotable.plugins.i18n) was not found amongst bundles: " + BundleUtil.toBundleNames(this.bundleContext.getBundles()));
        }
    }

    private void ensureI18nPluginIsEnabled() {
        this.pluginController.enablePlugins(new String[]{I18N_SYMBOLIC_NAME});
    }

    private static interface BundleManipulator {
        public boolean includeEntry(String var1);

        public void finish(Bundle var1, ZipOutputStream var2) throws IOException;
    }
}

