/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcStruct;
import redstone.xmlrpc.util.Base64;

public class XmlRpcValue {
    Object value;
    int type = -891985903;
    String memberName;
    private static final SimpleDateFormat[] dateFormatters = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss")};

    XmlRpcValue() {
    }

    void setType(int n) {
        this.type = n;
        if (n == 93090393) {
            this.value = new XmlRpcArray();
        } else if (n == -891974699) {
            this.value = new XmlRpcStruct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCharacterData(String string) throws XmlRpcException {
        block3 : switch (this.type) {
            case -891985903: {
                this.value = string;
                break;
            }
            case 3307: 
            case 104431: {
                this.value = new Integer(string);
                break;
            }
            case 3311: {
                this.value = new Long(string);
                break;
            }
            case 64711720: {
                this.value = new Boolean(Integer.parseInt(string) == 1);
                break;
            }
            case -1325958191: {
                this.value = new Double(string);
                break;
            }
            case -586971087: {
                for (int i = 0; i < dateFormatters.length; ++i) {
                    SimpleDateFormat simpleDateFormat = dateFormatters[i];
                    synchronized (simpleDateFormat) {
                        try {
                            this.value = dateFormatters[i].parse(string);
                            break block3;
                        }
                        catch (ParseException parseException) {
                            if (i == dateFormatters.length - 1) {
                                throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcValue.IllegalDate") + string, parseException);
                            }
                            continue;
                        }
                    }
                }
                break;
            }
            case -1396204209: {
                this.value = Base64.decode(string.getBytes());
                break;
            }
            case -891974699: {
                this.memberName = string;
            }
        }
    }

    void addChildValue(XmlRpcValue xmlRpcValue) {
        if (this.type == 93090393) {
            ((XmlRpcArray)this.value).add(xmlRpcValue.value);
        } else if (this.type == -891974699) {
            ((XmlRpcStruct)this.value).put(this.memberName, xmlRpcValue.value);
        } else {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcValue.UnexpectedNestedValue"));
        }
    }

    public int hashCode() {
        return this.type;
    }
}

