/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.HttpRequestMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthServlet {
    private static final Integer SC_FORBIDDEN = new Integer(403);
    private static final Map<String, Integer> PROBLEM_TO_HTTP_CODE = OAuth.Problems.TO_HTTP_CODE;

    public static OAuthMessage getMessage(HttpServletRequest request, String URL2) {
        int q;
        if (URL2 == null) {
            URL2 = request.getRequestURL().toString();
        }
        if ((q = URL2.indexOf(63)) >= 0) {
            URL2 = URL2.substring(0, q);
        }
        return new HttpRequestMessage(request, URL2);
    }

    public static String getRequestURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }

    public static void handleException(HttpServletResponse response, Exception e, String realm) throws IOException, ServletException {
        OAuthServlet.handleException(response, e, realm, true);
    }

    public static void handleException(HttpServletResponse response, Exception e, String realm, boolean sendBody) throws IOException, ServletException {
        if (e instanceof OAuthProblemException) {
            OAuthProblemException problem = (OAuthProblemException)((Object)e);
            Object httpCode = problem.getParameters().get("HTTP status");
            if (httpCode == null) {
                httpCode = PROBLEM_TO_HTTP_CODE.get(problem.getProblem());
            }
            if (httpCode == null) {
                httpCode = SC_FORBIDDEN;
            }
            response.reset();
            response.setStatus(Integer.parseInt(httpCode.toString()));
            OAuthMessage message = new OAuthMessage(null, null, problem.getParameters().entrySet());
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(realm));
            if (sendBody) {
                OAuthServlet.sendForm(response, message.getParameters());
            }
        } else {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException((Throwable)e);
        }
    }

    public static void sendForm(HttpServletResponse response, Iterable<? extends Map.Entry> parameters) throws IOException {
        response.resetBuffer();
        response.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        OAuth.formEncode(parameters, (OutputStream)response.getOutputStream());
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder html = new StringBuilder(s.length());
        block6: for (char c : s.toCharArray()) {
            switch (c) {
                case '<': {
                    html.append("&lt;");
                    continue block6;
                }
                case '>': {
                    html.append("&gt;");
                    continue block6;
                }
                case '&': {
                    html.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    html.append("&quot;");
                    continue block6;
                }
                default: {
                    html.append(c);
                }
            }
        }
        return html.toString();
    }
}

