/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira.webhook;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.plugin.remotable.plugin.product.EventMapper;
import com.atlassian.plugin.remotable.plugin.product.jira.JiraRestBeanMarshaler;
import com.atlassian.plugin.remotable.plugin.product.jira.webhook.IssueEventMapper;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.EventSerializers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JiraEventSerializerFactory
implements EventSerializerFactory<JiraEvent> {
    private static final Logger log = LoggerFactory.getLogger(JiraEventSerializerFactory.class);
    protected final List<EventMapper<JiraEvent>> mappers;

    public JiraEventSerializerFactory(JiraRestBeanMarshaler jiraRestBeanMarshaler) {
        this.mappers = ImmutableList.of((Object)new IssueEventMapper((JiraRestBeanMarshaler)Preconditions.checkNotNull((Object)jiraRestBeanMarshaler)));
    }

    public EventSerializer create(JiraEvent event) {
        for (EventMapper<JiraEvent> mapper : this.mappers) {
            if (!mapper.handles(event)) continue;
            return EventSerializers.forMap((Object)event, mapper.toMap(event));
        }
        log.warn(String.format("Event %s was not recognised by any Event to WebHook mapper.", event.getClass().getName()));
        return EventSerializers.forMap((Object)event, (Map)ImmutableMap.builder().build());
    }
}

