/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMapContainingValue<V>
extends TypeSafeMatcher<Map<?, V>> {
    private final Matcher<? super V> valueMatcher;

    public IsMapContainingValue(Matcher<? super V> valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matchesSafely(Map<?, V> item) {
        for (V value : item.values()) {
            if (!this.valueMatcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describeMismatchSafely(Map<?, V> map, Description mismatchDescription) {
        mismatchDescription.appendText("map was ").appendValueList("[", ", ", "]", map.entrySet());
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("map with value ").appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static <V> Matcher<? super Map<?, V>> hasValue(V value) {
        return IsMapContainingValue.hasValue(IsEqual.equalTo(value));
    }

    @Factory
    public static <V> Matcher<? super Map<?, V>> hasValue(Matcher<? super V> valueMatcher) {
        return new IsMapContainingValue<V>(valueMatcher);
    }
}

