/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.issuetab;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.ConditionProcessor;
import com.atlassian.plugin.remotable.plugin.module.ContainingRemoteCondition;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.issuetab.FixedIssueTabPanelModuleDescriptor;
import com.atlassian.plugin.remotable.plugin.module.jira.issuetab.IssueTabPage;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.dom4j.Element;

public final class IssueTabPageModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final IFrameRendererImpl iFrameRenderer;
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final ConditionProcessor conditionProcessor;
    private Element descriptor;
    private URI url;
    private DynamicDescriptorRegistration.Registration registration;

    public IssueTabPageModuleDescriptor(ModuleFactory moduleFactory, IFrameRendererImpl iFrameRenderer, DynamicDescriptorRegistration dynamicDescriptorRegistration, ConditionProcessor conditionProcessor) {
        super(moduleFactory);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.conditionProcessor = (ConditionProcessor)Preconditions.checkNotNull((Object)conditionProcessor);
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
        this.url = Dom4jUtils.getRequiredUriAttribute((Element)element, (String)"url");
    }

    public void enabled() {
        super.enabled();
        String panelName = Dom4jUtils.getRequiredAttribute((Element)this.descriptor, (String)"name");
        Element desc = this.descriptor.createCopy();
        String moduleKey = "issue-tab-page-" + Dom4jUtils.getRequiredAttribute((Element)this.descriptor, (String)"key");
        Condition condition = this.conditionProcessor.process(this.descriptor, desc, this.getPluginKey(), "#" + moduleKey + "-remote-condition");
        if (condition instanceof ContainingRemoteCondition) {
            moduleKey = moduleKey + "-remote-condition";
        }
        desc.addAttribute("key", moduleKey);
        desc.addElement("label").setText(panelName);
        desc.addAttribute("class", IssueTabPage.class.getName());
        IssueTabPanelModuleDescriptor moduleDescriptor = this.createDescriptor(moduleKey, desc, new IFrameParamsImpl(this.descriptor), condition);
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), new DescriptorToRegister((ModuleDescriptor)moduleDescriptor));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private IssueTabPanelModuleDescriptor createDescriptor(final String moduleKey, Element desc, final IFrameParams iFrameParams, final Condition condition) {
        try {
            desc.addAttribute("system", "true");
            FixedIssueTabPanelModuleDescriptor descriptor = new FixedIssueTabPanelModuleDescriptor((JiraAuthenticationContext)ComponentManager.getComponent(JiraAuthenticationContext.class), new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    return (T)((Object)new IssueTabPage(new IFrameContextImpl(IssueTabPageModuleDescriptor.this.getPluginKey(), IssueTabPageModuleDescriptor.this.url, moduleKey, iFrameParams), IssueTabPageModuleDescriptor.this.iFrameRenderer, condition));
                }
            });
            descriptor.init(this.conditionProcessor.getLoadablePlugin(this.getPlugin()), desc);
            return descriptor;
        }
        catch (Exception ex) {
            throw new PluginParseException((Throwable)ex);
        }
    }
}

