/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.scope.RequestScope;
import com.atlassian.jira.rest.v2.issue.scope.RequestScopeInterceptor;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.sal.api.ApplicationProperties;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.uri.UriTemplate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.MatchResult;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;

public class JiraRestBeanMarshaler
implements DisposableBean {
    private final ServiceTracker beanFactoryTracker;
    private final ApplicationProperties applicationProperties;
    private final JiraBaseUrls jiraBaseUrls;
    private final ProjectRoleManager projectRoleManager;

    public JiraRestBeanMarshaler(BundleContext bundleContext, ApplicationProperties applicationProperties, JiraBaseUrls jiraBaseUrls, ProjectRoleManager projectRoleManager) {
        Filter filter;
        this.applicationProperties = applicationProperties;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectRoleManager = projectRoleManager;
        try {
            filter = bundleContext.createFilter("(&(objectClass=org.springframework.beans.factory.BeanFactory)(Bundle-SymbolicName=com.atlassian.jira.rest-plugin))");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        this.beanFactoryTracker = new ServiceTracker(bundleContext, filter, null);
        this.beanFactoryTracker.open();
    }

    public JSONObject getRemoteIssue(final Issue issue) {
        final DefaultJaxbJsonMarshaller m = new DefaultJaxbJsonMarshaller();
        try {
            final BeanFactory beanFactory = (BeanFactory)this.beanFactoryTracker.waitForService(TimeUnit.SECONDS.toMillis(30L));
            final AtomicReference result = new AtomicReference();
            this.runInRequest(beanFactory, new Runnable(){

                @Override
                public void run() {
                    BeanBuilderFactory beanBuilderFactory = (BeanBuilderFactory)JiraRestBeanMarshaler.this.wrapService(new Class[]{BeanBuilderFactory.class}, beanFactory.getBean("beanBuilderFactory", BeanBuilderFactory.class));
                    IssueBean issueBean = beanBuilderFactory.newIssueBeanBuilder(issue, IncludedFields.includeAllByDefault(null)).build();
                    String text = m.marshal((Object)issueBean);
                    try {
                        result.set(new JSONObject(text));
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return (JSONObject)result.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot find bean factory for JIRA rest plugin");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getRemoteComment(Comment comment) {
        DefaultJaxbJsonMarshaller m = new DefaultJaxbJsonMarshaller();
        CommentJsonBean bean = CommentJsonBean.shortBean((Comment)comment, (JiraBaseUrls)this.jiraBaseUrls, (ProjectRoleManager)this.projectRoleManager);
        String data = m.marshal((Object)bean);
        try {
            return new JSONObject(data);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void runInRequest(BeanFactory beanFactory, Runnable runnable) throws IllegalAccessException, InvocationTargetException {
        RequestScope requestScope = (RequestScope)beanFactory.getBean("requestScope");
        RequestScopeInterceptor interceptor = new RequestScopeInterceptor(requestScope);
        interceptor.intercept((MethodInvocation)new MockMethodInvocation(runnable));
    }

    public void destroy() throws Exception {
        this.beanFactoryTracker.close();
    }

    protected Object wrapService(Class<?>[] interfaces, Object service) {
        return Proxy.newProxyInstance(service.getClass().getClassLoader(), interfaces, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler(service));
    }

    private class MockExtendedUriInfo
    implements ExtendedUriInfo {
        private MockExtendedUriInfo() {
        }

        public AbstractResourceMethod getMatchedMethod() {
            return null;
        }

        public Throwable getMappedThrowable() {
            return null;
        }

        public List<MatchResult> getMatchedResults() {
            return null;
        }

        public List<UriTemplate> getMatchedTemplates() {
            return null;
        }

        public List<PathSegment> getPathSegments(String name) {
            return null;
        }

        public List<PathSegment> getPathSegments(String name, boolean decode) {
            return null;
        }

        public String getPath() {
            return null;
        }

        public String getPath(boolean decode) {
            return null;
        }

        public List<PathSegment> getPathSegments() {
            return null;
        }

        public List<PathSegment> getPathSegments(boolean decode) {
            return null;
        }

        public URI getRequestUri() {
            return null;
        }

        public UriBuilder getRequestUriBuilder() {
            return UriBuilder.fromUri((String)JiraRestBeanMarshaler.this.applicationProperties.getBaseUrl());
        }

        public URI getAbsolutePath() {
            return null;
        }

        public UriBuilder getAbsolutePathBuilder() {
            return null;
        }

        public URI getBaseUri() {
            return null;
        }

        public UriBuilder getBaseUriBuilder() {
            return UriBuilder.fromUri((String)JiraRestBeanMarshaler.this.applicationProperties.getBaseUrl());
        }

        public MultivaluedMap<String, String> getPathParameters() {
            return null;
        }

        public MultivaluedMap<String, String> getPathParameters(boolean decode) {
            return null;
        }

        public MultivaluedMap<String, String> getQueryParameters() {
            return null;
        }

        public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
            return null;
        }

        public List<String> getMatchedURIs() {
            return null;
        }

        public List<String> getMatchedURIs(boolean decode) {
            return null;
        }

        public List<Object> getMatchedResources() {
            return null;
        }
    }

    private class MockHttpContext
    implements HttpContext {
        private MockHttpContext() {
        }

        public ExtendedUriInfo getUriInfo() {
            return new MockExtendedUriInfo();
        }

        public HttpRequestContext getRequest() {
            return null;
        }

        public HttpResponseContext getResponse() {
            return null;
        }

        public Map<String, Object> getProperties() {
            return null;
        }

        public boolean isTracingEnabled() {
            return false;
        }

        public void trace(String s) {
        }
    }

    private class MockMethodInvocation
    implements MethodInvocation {
        private final Runnable runnable;

        public MockMethodInvocation(Runnable runnable) {
            this.runnable = runnable;
        }

        public Object getResource() {
            return null;
        }

        public HttpContext getHttpContext() {
            return new MockHttpContext();
        }

        public AbstractResourceMethod getMethod() {
            return null;
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public void invoke() throws IllegalAccessException, InvocationTargetException {
            this.runnable.run();
        }
    }

    private static class ContextClassLoaderSettingInvocationHandler
    implements InvocationHandler {
        private final Object service;

        ContextClassLoaderSettingInvocationHandler(Object service) {
            this.service = service;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Thread thread = Thread.currentThread();
            ClassLoader ccl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.service.getClass().getClassLoader());
                Object object = method.invoke(this.service, objects);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                thread.setContextClassLoader(ccl);
            }
        }
    }
}

