/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.confluence.webhook;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.search.v2.query.BoostingQuery;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.remotable.plugin.product.confluence.webhook.ConfluenceEventMapper;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SearchPerformedEventMapper
extends ConfluenceEventMapper {
    public SearchPerformedEventMapper(UserManager userManager, SettingsManager confluenceSettingsManager) {
        super(userManager, confluenceSettingsManager);
    }

    @Override
    public boolean handles(ConfluenceEvent e) {
        return e instanceof SearchPerformedEvent;
    }

    @Override
    public Map<String, Object> toMap(ConfluenceEvent e) {
        SearchPerformedEvent event = (SearchPerformedEvent)e;
        String queryText = "";
        if (event.getSearchQuery() instanceof BoostingQuery) {
            queryText = ((BoostingQuery)event.getSearchQuery()).getSearchQueryParameters().getQuery();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"timestamp", (Object)event.getTimestamp());
        builder.put((Object)"query", (Object)queryText);
        builder.put((Object)"results", (Object)event.getNumberOfResults());
        if (event.getUser() != null) {
            builder.put((Object)"user", (Object)event.getUser().getName());
        }
        return builder.build();
    }
}

