/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.projectconfig;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.DefaultWebItemContext;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.WebItemContext;
import com.atlassian.plugin.remotable.plugin.module.WebItemCreator;
import com.atlassian.plugin.remotable.plugin.module.jira.projectconfig.IFrameProjectConfigTabServlet;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.module.page.IFramePageServlet;
import com.atlassian.plugin.remotable.plugin.module.page.PageInfo;
import com.atlassian.plugin.remotable.plugin.module.page.RemotePageDescriptorCreator;
import com.atlassian.plugin.remotable.plugin.module.permission.jira.IsProjectAdminCondition;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;

public final class ProjectConfigTabModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final ProjectConfigTabPageBuilder projectConfigTabPageBuilder;
    private final BundleContext bundleContext;
    private final IFrameRendererImpl iFrameRenderer;
    private final UserManager userManager;
    private Element descriptor;
    private WebItemCreator.Builder webItemCreatorBuilder;
    private DynamicDescriptorRegistration.Registration registration;
    private Condition condition;

    public ProjectConfigTabModuleDescriptor(ModuleFactory moduleFactory, DynamicDescriptorRegistration dynamicDescriptorRegistration, BundleContext bundleContext, IFrameRendererImpl iFrameRenderer, UserManager userManager, WebItemCreator webItemCreator, JiraAuthenticationContext authenticationContext) {
        super(moduleFactory);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.webItemCreatorBuilder = ((WebItemCreator)Preconditions.checkNotNull((Object)webItemCreator)).newBuilder();
        this.condition = new IsProjectAdminCondition((JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext));
        this.projectConfigTabPageBuilder = new ProjectConfigTabPageBuilder();
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
    }

    public void enabled() {
        super.enabled();
        String key = Dom4jUtils.getRequiredAttribute((Element)this.descriptor, (String)"key");
        String location = Dom4jUtils.getRequiredAttribute((Element)this.descriptor, (String)"location");
        int weight = Integer.parseInt(Dom4jUtils.getRequiredAttribute((Element)this.descriptor, (String)"weight"));
        Iterable<DescriptorToRegister> descriptors = this.projectConfigTabPageBuilder.setWebItemContext(new DefaultWebItemContext("atl.jira.proj.config/" + location, weight, (Map<String, String>)ImmutableMap.of((Object)"projectKey", (Object)"$!helper.project.key"))).setMetaTagContent("adminActiveTab", "webitem-".concat(key)).build(this.getPlugin(), this.descriptor);
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), descriptors);
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private class ProjectConfigTabPageBuilder {
        private Map<String, String> metaTagsContent = Maps.newHashMap();

        private ProjectConfigTabPageBuilder() {
        }

        public ProjectConfigTabPageBuilder setWebItemContext(WebItemContext webItemContext) {
            ProjectConfigTabModuleDescriptor.this.webItemCreatorBuilder.setContextParams(webItemContext.getContextParams()).setPreferredSectionKey(webItemContext.getPreferredSectionKey()).setPreferredWeight(webItemContext.getPreferredWeight());
            return this;
        }

        public ProjectConfigTabPageBuilder setMetaTagContent(String name, String content) {
            this.metaTagsContent.put(name, content);
            return this;
        }

        public Iterable<DescriptorToRegister> build(Plugin plugin, Element descriptor) {
            String key = Dom4jUtils.getRequiredAttribute((Element)descriptor, (String)"key");
            URI url = Dom4jUtils.getRequiredUriAttribute((Element)descriptor, (String)"url");
            URI localUrl = RemotePageDescriptorCreator.createLocalUrl(plugin.getKey(), key);
            DescriptorToRegister webItemModuleDescriptor = new DescriptorToRegister((ModuleDescriptor)ProjectConfigTabModuleDescriptor.this.webItemCreatorBuilder.build(plugin, key, localUrl, descriptor));
            return ImmutableSet.of((Object)this.createServletDescriptor(plugin, descriptor, key, url, localUrl), (Object)webItemModuleDescriptor);
        }

        private DescriptorToRegister createServletDescriptor(final Plugin plugin, Element e, String key, final URI path, URI localUrl) {
            final String pageName = Dom4jUtils.getRequiredAttribute((Element)e, (String)"name");
            Element config = e.createCopy();
            final String moduleKey = "servlet-" + key;
            config.addAttribute("key", moduleKey);
            config.addAttribute("class", IFramePageServlet.class.getName());
            config.addElement("url-pattern").setText(localUrl + "");
            config.addElement("url-pattern").setText(localUrl + "/*");
            final IFrameParamsImpl params = new IFrameParamsImpl(e);
            ServletModuleDescriptor descriptor = new ServletModuleDescriptor(new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    PageInfo pageInfo = new PageInfo("", "-project-admin", pageName, ProjectConfigTabModuleDescriptor.this.condition, ProjectConfigTabPageBuilder.this.metaTagsContent);
                    return (T)((Object)new IFrameProjectConfigTabServlet(pageInfo, ProjectConfigTabModuleDescriptor.this.iFrameRenderer, new IFrameContextImpl(plugin.getKey(), path, moduleKey, params), ProjectConfigTabModuleDescriptor.this.userManager));
                }
            }, OsgiServiceUtils.getService(ProjectConfigTabModuleDescriptor.this.bundleContext, ServletModuleManager.class));
            descriptor.init(plugin, config);
            return new DescriptorToRegister((ModuleDescriptor)descriptor);
        }
    }
}

