/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.issuetab;

import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.plugin.remotable.plugin.module.ContainingRemoteCondition;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.web.Condition;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTabPage
extends AbstractIssueTabPanel2 {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPage.class);
    private final IFrameRendererImpl iFrameRenderer;
    private final Condition condition;
    private final IFrameContext iFrameContext;

    public IssueTabPage(IFrameContext iFrameContext, IFrameRendererImpl iFrameRenderer, Condition condition) {
        this.iFrameContext = iFrameContext;
        this.iFrameRenderer = iFrameRenderer;
        this.condition = condition;
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        HashMap context = Maps.newHashMap();
        context.put("helper", Collections.singletonMap("project", request.issue().getProjectObject()));
        context.put("issue", request.issue());
        return ShowPanelReply.create((boolean)(this.condition != null ? this.condition.shouldDisplay((Map)context) : true));
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        return GetActionsReply.create((IssueAction[])new IssueAction[]{new IFrameIssueAction(request)});
    }

    public class IFrameIssueAction
    implements IssueAction {
        private final GetActionsRequest request;

        public IFrameIssueAction(GetActionsRequest request) {
            this.request = request;
        }

        public String getHtml() {
            StringWriter writer = new StringWriter();
            try {
                HashMap extraParams = Maps.newHashMap();
                extraParams.put("ctx_issue_key", new String[]{this.request.issue().getKey()});
                String remoteUser = this.request.isAnonymous() ? null : this.request.remoteUser().getName();
                String iframe = IssueTabPage.this.iFrameRenderer.render(IssueTabPage.this.iFrameContext, "", extraParams, remoteUser);
                if (IssueTabPage.this.condition != null && IssueTabPage.this.condition instanceof ContainingRemoteCondition) {
                    iframe = "<div>" + iframe + "</div>";
                }
                writer.write(iframe);
            }
            catch (PermissionDeniedException ex) {
                writer.write("Unauthorized to view this tab");
                log.warn("Unauthorized view of tab");
            }
            catch (IOException e) {
                writer.write("Unable to render tab: " + e.getMessage());
                log.error("Error rendering tab", (Throwable)e);
            }
            return writer.toString();
        }

        public Date getTimePerformed() {
            throw new UnsupportedOperationException();
        }

        public boolean isDisplayActionAllTab() {
            return false;
        }
    }
}

