/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.plugin.module.ConditionLoadingPlugin;
import com.atlassian.plugin.remotable.plugin.module.ContainingRemoteCondition;
import com.atlassian.plugin.remotable.spi.module.RemoteCondition;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionProcessor {
    private final ProductAccessor productAccessor;
    private final AutowireCapablePlugin remotablePlugin;

    @Autowired
    public ConditionProcessor(ProductAccessor productAccessor, PluginRetrievalService pluginRetrievalService) {
        this.productAccessor = productAccessor;
        this.remotablePlugin = (AutowireCapablePlugin)pluginRetrievalService.getPlugin();
    }

    public Condition process(Element oldConfig, Element newConfig, String pluginKey) {
        return this.process(oldConfig, newConfig, pluginKey, null);
    }

    public Condition process(Element oldConfig, Element newConfig, String pluginKey, String toHideSelector) {
        List<String> contextParamKeys = this.getContextParameters(oldConfig);
        newConfig.elements("conditions").clear();
        Element conditions = oldConfig.element("conditions");
        String remoteConditionUrl = null;
        if (conditions != null) {
            for (Element cElement : conditions.elements("condition")) {
                String cName = cElement.attributeValue("name");
                String cUrl = cElement.attributeValue("url");
                if (cName != null && cUrl != null) {
                    throw new PluginParseException("Name and url cannot be defined on a condition");
                }
                if (cName == null && cUrl == null) {
                    throw new PluginParseException("Either the name or url must be defined on a condition");
                }
                Element condElement = newConfig.addElement("condition");
                if (Boolean.parseBoolean(StringUtils.escape((String)cElement.attributeValue("invert")))) {
                    condElement.addAttribute("invert", "true");
                }
                if (cName != null) {
                    condElement.addAttribute("class", ((Class)this.productAccessor.getConditions().get(cName)).getName());
                    for (Object child : cElement.elements()) {
                        if (!(child instanceof Element)) continue;
                        Element el = (Element)child;
                        condElement.add(el.createCopy());
                    }
                    continue;
                }
                remoteConditionUrl = cUrl;
                if (toHideSelector == null) {
                    String hash = this.createUniqueUrlHash(pluginKey, cUrl);
                    toHideSelector = "." + hash;
                }
                String paramList = contextParamKeys.isEmpty() ? "" : StringUtils.join(contextParamKeys, (String)",");
                condElement.addAttribute("class", RemoteCondition.class.getName());
                condElement.addElement("param").addAttribute("name", "pluginKey").addText(pluginKey).getParent().addElement("param").addAttribute("name", "url").addText(cUrl).getParent().addElement("param").addAttribute("name", "contextParams").addText(paramList).getParent().addElement("param").addAttribute("name", "toHideSelector").addText(toHideSelector);
            }
        }
        ConditionElementParser conditionElementParser = new ConditionElementParser(new ConditionElementParser.ConditionFactory(){

            public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
                try {
                    return (Condition)ConditionProcessor.this.remotablePlugin.autowire(((Plugin)ConditionProcessor.this.remotablePlugin).loadClass(className, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new ConditionLoadingException((Throwable)e);
                }
            }
        });
        if (newConfig.elements("condition").size() > 1) {
            Element root = newConfig.addElement("conditions").addAttribute("type", "AND");
            for (Element cond : newConfig.elements("condition")) {
                root.add(cond.detach());
            }
        }
        Condition aggregateCondition = conditionElementParser.makeConditions((Plugin)this.remotablePlugin, newConfig, 1);
        return remoteConditionUrl != null ? new ContainingRemoteCondition(aggregateCondition, remoteConditionUrl) : aggregateCondition;
    }

    public String createUniqueUrlHash(String pluginKey, String cUrl) {
        return "ap-hash-" + (cUrl + ":" + pluginKey).hashCode();
    }

    public Plugin getLoadablePlugin(Plugin plugin) {
        return new ConditionLoadingPlugin(this.remotablePlugin, plugin, Sets.newHashSet(this.productAccessor.getConditions().values()));
    }

    private List<String> getContextParameters(Element oldConfig) {
        Element contextParameters = oldConfig.element("context-parameters");
        if (contextParameters != null) {
            return Lists.transform((List)contextParameters.elements("context-parameter"), (Function)new Function<Element, String>(){

                public String apply(@Nullable Element input) {
                    return input.attributeValue("name");
                }
            });
        }
        return Collections.emptyList();
    }
}

