/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira;

import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.JsonRpcApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.MutablePermission;
import com.atlassian.plugin.remotable.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.RpcEncodedSoapApiScopeHelper;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

abstract class JiraScope
implements ApiScope,
MutablePermission {
    private final RpcEncodedSoapApiScopeHelper soapScopeHelper;
    private final JsonRpcApiScopeHelper jsonrpcScopeHelper;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private RestApiScopeHelper restApiScopeHelper;
    private String name;
    private String description;

    protected JiraScope(Collection<String> methods, Collection<RestApiScopeHelper.RestScope> resources) {
        this.soapScopeHelper = new RpcEncodedSoapApiScopeHelper("/rpc/soap/jirasoapservice-v2", "http://soap.rpc.jira.atlassian.com", methods);
        this.jsonrpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/jirasoapservice-v2", methods);
        this.restApiScopeHelper = new RestApiScopeHelper(resources);
        this.apiResourceInfo = Iterables.concat((Iterable)this.soapScopeHelper.getApiResourceInfos(), (Iterable)this.jsonrpcScopeHelper.getApiResourceInfos(), (Iterable)this.restApiScopeHelper.getApiResourceInfos());
    }

    public boolean allow(HttpServletRequest request, String user) {
        return this.soapScopeHelper.allow(request, user) || this.jsonrpcScopeHelper.allow(request, user) || this.restApiScopeHelper.allow(request, user);
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

