/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.confluence;

import com.atlassian.confluence.xmlrpc.client.api.ConfluenceAdminClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceAttachmentClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceBlogClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceLabelClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceNotificationClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluencePageClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceSpaceClient;
import com.atlassian.confluence.xmlrpc.client.api.ConfluenceUserClient;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.permission.scope.DownloadScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.JsonRpcApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.MutablePermission;
import com.atlassian.plugin.remotable.spi.permission.scope.RestApiScopeHelper;
import com.atlassian.plugin.remotable.spi.permission.scope.XmlRpcApiScopeHelper;
import com.atlassian.plugin.remotable.spi.util.RequirePermission;
import com.atlassian.velocity.htmlsafe.util.Check;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

abstract class ConfluenceScope
implements ApiScope,
MutablePermission {
    private final XmlRpcApiScopeHelper v2XmlRpcApiScopeHelper;
    private final XmlRpcApiScopeHelper v1XmlRpcApiScopeHelper;
    private final JsonRpcApiScopeHelper v2JsonRpcScopeHelper;
    private final JsonRpcApiScopeHelper v1JsonRpcScopeHelper;
    private RestApiScopeHelper restApiScopeHelper;
    private final Iterable<ApiResourceInfo> apiResourceInfo;
    private static final Map<String, Collection<String>> serviceClassMethodsByPermission = Collections.unmodifiableMap(ConfluenceScope.scanServiceClasses(ConfluencePageClient.class, ConfluenceAdminClient.class, ConfluenceAttachmentClient.class, ConfluenceLabelClient.class, ConfluenceNotificationClient.class, ConfluenceSpaceClient.class, ConfluenceUserClient.class, ConfluenceBlogClient.class));
    private final String permissionName;
    private final DownloadScopeHelper downloadScopeHelper;
    private String name;
    private String description;

    private static Map<String, Collection<String>> scanServiceClasses(Class<?> ... serviceInterfaces) {
        HashMultimap result = HashMultimap.create();
        for (Class<?> serviceClass : serviceInterfaces) {
            for (Method method : serviceClass.getMethods()) {
                RequirePermission permission = method.getAnnotation(RequirePermission.class);
                if (permission == null) continue;
                result.put((Object)permission.value(), (Object)method.getName());
            }
        }
        return result.asMap();
    }

    protected ConfluenceScope(String permissionName) {
        this(permissionName, Collections.emptyList());
    }

    protected ConfluenceScope(String permissionName, Collection<RestApiScopeHelper.RestScope> resources) {
        this(permissionName, resources, new DownloadScopeHelper(new String[0]));
    }

    protected ConfluenceScope(String permissionName, Collection<RestApiScopeHelper.RestScope> resources, DownloadScopeHelper downloadScopeHelper) {
        this.permissionName = permissionName;
        Collection<String> methods = serviceClassMethodsByPermission.get(permissionName);
        Check.notNull(methods);
        this.v1JsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/confluenceservice-v1", methods);
        this.v2JsonRpcScopeHelper = new JsonRpcApiScopeHelper("/rpc/json-rpc/confluenceservice-v2", methods);
        this.v1XmlRpcApiScopeHelper = new XmlRpcApiScopeHelper("/rpc/xmlrpc", Collections2.transform(methods, this.xmlRpcTransform("confluence1")));
        this.v2XmlRpcApiScopeHelper = new XmlRpcApiScopeHelper("/rpc/xmlrpc", Collections2.transform(methods, this.xmlRpcTransform("confluence2")));
        this.restApiScopeHelper = new RestApiScopeHelper(resources);
        this.downloadScopeHelper = downloadScopeHelper;
        this.apiResourceInfo = Iterables.concat((Iterable[])new Iterable[]{this.v1JsonRpcScopeHelper.getApiResourceInfos(), this.v2JsonRpcScopeHelper.getApiResourceInfos(), this.v1XmlRpcApiScopeHelper.getApiResourceInfos(), this.v2XmlRpcApiScopeHelper.getApiResourceInfos(), downloadScopeHelper.getApiResourceInfos()});
    }

    public String getKey() {
        return this.permissionName;
    }

    public boolean allow(HttpServletRequest request, String user) {
        return this.v1XmlRpcApiScopeHelper.allow(request, user) || this.v2XmlRpcApiScopeHelper.allow(request, user) || this.v1JsonRpcScopeHelper.allow(request, user) || this.v2JsonRpcScopeHelper.allow(request, user) || this.restApiScopeHelper.allow(request, user) || this.downloadScopeHelper.allow(request, user);
    }

    public Iterable<ApiResourceInfo> getApiResourceInfos() {
        return this.apiResourceInfo;
    }

    private Function<String, String> xmlRpcTransform(final String serviceName) {
        return new Function<String, String>(){

            public String apply(String from) {
                return serviceName + "." + from;
            }
        };
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

