/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.contextparameter;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RequestContextParameters {
    private final Map<String, String> allContextParameters;
    private final Set<String> queryParameters;
    private final Set<String> headerParameters;

    RequestContextParameters(Map<String, String> allContextParameters, Set<String> queryParameters, Set<String> headerParameters) {
        this.allContextParameters = allContextParameters;
        this.queryParameters = queryParameters;
        this.headerParameters = headerParameters;
    }

    public Map<String, String> getHeaders() {
        HashMap headers = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.allContextParameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!this.shouldIncludeInHeader(name)) continue;
            StringBuilder sb = new StringBuilder("AP-CTX-");
            sb.append(name.replace('_', '-'));
            headers.put(sb.toString(), value);
        }
        return headers;
    }

    public Map<String, String> getQueryParameters() {
        HashMap params = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.allContextParameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!this.shouldIncludeInQueryString(name)) continue;
            params.put("ctx_" + name, value);
        }
        return params;
    }

    private boolean shouldIncludeInQueryString(String key) {
        return this.queryParameters.contains(key);
    }

    private boolean shouldIncludeInHeader(String key) {
        return this.headerParameters.contains(key);
    }
}

