/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira.webhook;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.plugin.remotable.plugin.product.jira.JiraRestBeanMarshaler;
import com.atlassian.plugin.remotable.plugin.product.jira.webhook.JiraEventMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueEventMapper
extends JiraEventMapper {
    private static final Logger log = LoggerFactory.getLogger(IssueEventMapper.class);
    private final JiraRestBeanMarshaler jiraRestBeanMarshaler;

    public IssueEventMapper(JiraRestBeanMarshaler jiraRestBeanMarshaler) {
        this.jiraRestBeanMarshaler = (JiraRestBeanMarshaler)Preconditions.checkNotNull((Object)jiraRestBeanMarshaler);
    }

    @Override
    public boolean handles(JiraEvent event) {
        return event instanceof IssueEvent;
    }

    @Override
    public Map<String, Object> toMap(JiraEvent event) {
        IssueEvent issueEvent = (IssueEvent)event;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.toMap(event));
        if (issueEvent.getUser() != null) {
            builder.put((Object)"user", (Object)issueEvent.getUser().getName());
        }
        try {
            builder.put((Object)"issue", this.asMap(this.jiraRestBeanMarshaler.getRemoteIssue(issueEvent.getIssue())));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (EventType.ISSUE_UPDATED_ID.equals(issueEvent.getEventTypeId()) && issueEvent.getChangeLog() != null) {
            builder.put((Object)"updatedFields", this.changeGroupToList(issueEvent.getChangeLog()));
        }
        if (issueEvent.getComment() != null) {
            try {
                builder.put((Object)"comment", this.asMap(this.jiraRestBeanMarshaler.getRemoteComment(issueEvent.getComment())));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.build();
    }

    private Object asMap(JSONObject object) throws JSONException {
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (object.length() > 0) {
            for (String name : JSONObject.getNames((JSONObject)object)) {
                Object value = object.get(name);
                if (value instanceof JSONObject) {
                    map.put((Object)name, this.asMap((JSONObject)value));
                    continue;
                }
                if (value instanceof JSONArray) {
                    map.put((Object)name, this.asList((JSONArray)value));
                    continue;
                }
                if (value instanceof JSONString) {
                    map.put((Object)name, (Object)value.toString());
                    continue;
                }
                map.put((Object)name, value);
            }
        }
        return map.build();
    }

    private List<Object> asList(JSONArray array) throws JSONException {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                list.add(this.asMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                list.add(this.asList((JSONArray)value));
                continue;
            }
            if (value instanceof JSONString) {
                list.add((Object)value.toString());
                continue;
            }
            list.add(value);
        }
        return list.build();
    }

    private List<Map<String, Object>> changeGroupToList(GenericValue changeLog) {
        ArrayList fields = Lists.newArrayList();
        try {
            for (GenericValue changeItem : changeLog.getRelated("ChildChangeItem")) {
                fields.add(ImmutableMap.of((Object)"name", (Object)changeItem.get("field").toString(), (Object)"oldValue", (Object)this.getValueOrBlank(changeItem, "oldstring"), (Object)"newValue", (Object)this.getValueOrBlank(changeItem, "newstring")));
            }
        }
        catch (GenericEntityException e) {
            log.warn("Error serializing updated event: " + (Object)((Object)e), (Throwable)e);
        }
        return fields;
    }

    private String getValueOrBlank(GenericValue gv, String name) {
        Object value = gv.get(name);
        return value != null ? value.toString() : "";
    }
}

