/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.loader.universalbinary;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.DelegatingUBFilter;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.DelegatingUBServlet;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.StaticResourceServlet;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBFilterConfig;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBServletConfig;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBServletContextWrapper;
import com.atlassian.plugin.servlet.filter.IteratingFilterChain;
import com.atlassian.plugin.servlet.util.DefaultPathMapper;
import com.atlassian.plugin.servlet.util.PathMapper;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ubDispatchFilter")
public class UBDispatchFilter
implements DisposableBean,
Filter {
    private final PathMapper servletPathMapper;
    private final PathMapper filterPathMapper;
    private final Map<String, DispatcherEntry<HttpServlet>> servlets;
    private final Map<String, DispatcherEntry<Filter>> filters;
    private static final SecureRandom random = SecureRandomFactory.newInstance();
    private final PluginAccessor pluginAccessor;
    private static final Logger log = LoggerFactory.getLogger(UBDispatchFilter.class);
    private volatile Map<String, ServletContext> servletContextsByApp;
    private final PluginEventManager pluginEventManager;
    private final ApplicationProperties applicationProperties;
    private final Pattern APP_KEY_FINDER = Pattern.compile("/app/([^/]*)/.*");

    @Autowired
    public UBDispatchFilter(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.applicationProperties = applicationProperties;
        this.servlets = CopyOnWriteMap.newHashMap();
        this.filters = CopyOnWriteMap.newHashMap();
        this.servletPathMapper = new DefaultPathMapper();
        this.filterPathMapper = new DefaultPathMapper();
        pluginEventManager.register((Object)this);
    }

    public String getLocalMountBaseUrl(String appKey) {
        return this.applicationProperties.getBaseUrl() + UBDispatchFilter.getLocalMountBasePath(appKey);
    }

    public static String getLocalMountBasePath(String appKey) {
        return "/app/" + appKey;
    }

    public void mountServlet(String appKey, HttpServlet httpServlet, String ... urlPatterns) {
        Plugin plugin = this.pluginAccessor.getPlugin(appKey);
        ClassLoader cl = plugin.getClassLoader();
        DispatcherEntry servletEntry = new DispatcherEntry();
        servletEntry.appKey = appKey;
        servletEntry.dispatcher = new DelegatingUBServlet(httpServlet, cl, urlPatterns[0]);
        servletEntry.paths = urlPatterns;
        this.servlets.put(servletEntry.key, servletEntry);
        for (String urlPattern : urlPatterns) {
            this.servletPathMapper.put(servletEntry.key, UBDispatchFilter.getLocalMountBasePath(appKey) + urlPattern);
        }
    }

    public void mountFilter(String appKey, Filter filter, String[] urlPatterns) {
        Plugin plugin = this.pluginAccessor.getPlugin(appKey);
        ClassLoader cl = plugin.getClassLoader();
        DispatcherEntry entry = new DispatcherEntry();
        entry.appKey = appKey;
        entry.dispatcher = new DelegatingUBFilter(filter, cl);
        entry.paths = urlPatterns;
        this.filters.put(entry.key, entry);
        for (String urlPattern : urlPatterns) {
            this.filterPathMapper.put(entry.key, UBDispatchFilter.getLocalMountBasePath(appKey) + urlPattern);
            if (!urlPattern.equals("/")) continue;
            this.filterPathMapper.put(entry.key, UBDispatchFilter.getLocalMountBasePath(appKey));
        }
    }

    public void mountResources(String appKey, String resourcePrefix, String urlPattern) {
        Plugin plugin = this.pluginAccessor.getPlugin(appKey);
        ClassLoader cl = plugin.getClassLoader();
        DispatcherEntry entry = new DispatcherEntry();
        entry.dispatcher = new DelegatingUBServlet(new StaticResourceServlet(plugin, resourcePrefix), cl, resourcePrefix);
        entry.appKey = appKey;
        this.servletPathMapper.put(appKey, UBDispatchFilter.getLocalMountBasePath(appKey) + urlPattern);
        this.servlets.put(appKey, entry);
    }

    @PluginEventListener
    public void unregister(PluginDisabledEvent event) {
        String appKey = event.getPlugin().getKey();
        for (DispatcherEntry<HttpServlet> dispatcherEntry : this.servlets.values()) {
            if (!appKey.equals(dispatcherEntry.appKey)) continue;
            this.servlets.remove(dispatcherEntry.key);
            this.servletPathMapper.put(dispatcherEntry.key, null);
            ((HttpServlet)dispatcherEntry.dispatcher).destroy();
        }
        for (DispatcherEntry<HttpServlet> dispatcherEntry : this.filters.values()) {
            if (!appKey.equals(dispatcherEntry.appKey)) continue;
            this.filters.remove(dispatcherEntry.key);
            this.filterPathMapper.put(dispatcherEntry.key, null);
            ((Filter)dispatcherEntry.dispatcher).destroy();
        }
    }

    public void init(final FilterConfig filterConfig) throws ServletException {
        this.servletContextsByApp = new MapMaker().makeComputingMap((Function)new Function<String, ServletContext>(){

            public ServletContext apply(String appKey) {
                return new UBServletContextWrapper(UBDispatchFilter.getLocalMountBasePath(appKey), UBDispatchFilter.this.pluginAccessor.getPlugin(appKey), filterConfig.getServletContext(), new ConcurrentHashMap<String, Object>(), Collections.<String, String>emptyMap());
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Matcher m;
        HttpServletRequest req = (HttpServletRequest)request;
        String uri = UBDispatchFilter.getUri(req);
        String key = this.servletPathMapper.get(uri);
        if (key == null && (m = this.APP_KEY_FINDER.matcher(uri)).matches()) {
            key = m.group(1);
        }
        final String servletKey = key;
        ArrayList filterList = Lists.newArrayList();
        for (String filterKey : this.filterPathMapper.getAll(uri)) {
            filterList.add(this.getFilter(filterKey));
        }
        filterList.add(new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void destroy() {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (servletKey != null) {
                    HttpServlet servlet = UBDispatchFilter.this.getServlet(servletKey);
                    servlet.service(request, response);
                } else {
                    chain.doFilter(request, response);
                }
            }
        });
        IteratingFilterChain localFilterChain = new IteratingFilterChain(filterList.iterator(), chain);
        localFilterChain.doFilter(request, response);
    }

    private Filter getFilter(String filterKey) throws ServletException {
        DispatcherEntry<Filter> entry = this.filters.get(filterKey);
        if (entry == null) {
            this.filterPathMapper.put(filterKey, null);
            return null;
        }
        if (!entry.initialized) {
            UBFilterConfig filterConfig = new UBFilterConfig(filterKey, Collections.<String, String>emptyMap(), this.servletContextsByApp.get(entry.appKey));
            ((Filter)entry.dispatcher).init((FilterConfig)filterConfig);
            entry.initialized = true;
        }
        return (Filter)entry.dispatcher;
    }

    private HttpServlet getServlet(String servletKey) throws ServletException {
        DispatcherEntry<HttpServlet> entry = this.servlets.get(servletKey);
        if (entry == null) {
            this.servletPathMapper.put(servletKey, null);
            throw new IllegalStateException("Servlet not found but expected: " + servletKey);
        }
        if (!entry.initialized) {
            UBServletConfig servletConfig = new UBServletConfig(servletKey, Collections.<String, String>emptyMap(), this.servletContextsByApp.get(entry.appKey));
            ((HttpServlet)entry.dispatcher).init((ServletConfig)servletConfig);
            entry.initialized = true;
        }
        return (HttpServlet)entry.dispatcher;
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    private static String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = UBDispatchFilter.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    private static String getServletPath(HttpServletRequest request) {
        int endIndex;
        int pos;
        String servletPath = request.getServletPath();
        String requestUri = request.getRequestURI();
        if (requestUri != null && servletPath != null && !requestUri.endsWith(servletPath) && (pos = requestUri.indexOf(servletPath)) > -1) {
            servletPath = requestUri.substring(requestUri.indexOf(servletPath));
        }
        if (null != servletPath && !"".equals(servletPath)) {
            return servletPath;
        }
        int startIndex = request.getContextPath().equals("") ? 0 : request.getContextPath().length();
        int n = endIndex = request.getPathInfo() == null ? requestUri.length() : requestUri.lastIndexOf(request.getPathInfo());
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        return requestUri.substring(startIndex, endIndex);
    }

    static /* synthetic */ SecureRandom access$300() {
        return random;
    }

    private static class DispatcherEntry<M> {
        public final String key = String.valueOf(UBDispatchFilter.access$300().nextLong());
        public String appKey;
        public M dispatcher;
        public String[] paths;
        public volatile boolean initialized = false;

        private DispatcherEntry() {
        }
    }
}

