/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.installer;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.remotable.plugin.util.zip.ZipBuilder;
import com.atlassian.plugin.remotable.plugin.util.zip.ZipHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.springframework.stereotype.Component;

@Component
public class RemotePluginArtifactFactory {
    public static final String CLASSES_TO_INCLUDE_CLASS_PATH = "com/atlassian/plugin/remotable/kit/common/ClassesToInclude.class";
    private final byte[] classesToIncludeClass = this.extractClassesToIncludeClass();

    public PluginArtifact create(URI registrationUrl, final Document document, String username) {
        String pluginKey = document.getRootElement().attributeValue("key");
        this.changeDescriptorToIncludeRemotePluginHeader(registrationUrl, document, username);
        return new JarPluginArtifact(ZipBuilder.buildZip("install-" + pluginKey, new ZipHandler(){

            @Override
            public void build(ZipBuilder builder) throws IOException {
                builder.addFile("atlassian-plugin.xml", document);
                builder.addFile(RemotePluginArtifactFactory.CLASSES_TO_INCLUDE_CLASS_PATH, new ByteArrayInputStream(RemotePluginArtifactFactory.this.classesToIncludeClass));
            }
        }));
    }

    private void changeDescriptorToIncludeRemotePluginHeader(URI registrationUrl, Document document, String username) {
        document.getRootElement().element("plugin-info").addElement("bundle-instructions").addElement("Remote-Plugin").addText("installer;user=\"" + username + "\";date=\"" + System.currentTimeMillis() + "\"" + ";registration-url=\"" + registrationUrl + "\"");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractClassesToIncludeClass() {
        byte[] byArray;
        InputStream in;
        block6: {
            in = null;
            try {
                ZipEntry entry;
                in = this.getClass().getResourceAsStream("/remotable-plugins-kit-common.jar");
                ZipInputStream zin = new ZipInputStream(in);
                while ((entry = zin.getNextEntry()) != null) {
                    if (!CLASSES_TO_INCLUDE_CLASS_PATH.equals(entry.getName())) continue;
                    byArray = IOUtils.toByteArray((InputStream)zin);
                    break block6;
                }
                throw new IllegalStateException("Couldn't find com.atlassian.plugin.remotable.kit.common.ClassesToInclude");
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from remotable-plugins-kit-common.jar", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return byArray;
    }
}

