/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.permission;

import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.module.permission.InputConsumingHttpServletRequest;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiScopingFilter
implements Filter {
    private final PermissionManager permissionManager;
    private final UserManager userManager;
    private static final Logger log = LoggerFactory.getLogger(ApiScopingFilter.class);
    public static final String PLUGIN_KEY = "Plugin-Key";

    public ApiScopingFilter(PermissionManager permissionManager, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.userManager = userManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String clientKey = ApiScopingFilter.extractClientKey(req);
        if (clientKey != null) {
            InputConsumingHttpServletRequest inputConsumingRequest = new InputConsumingHttpServletRequest(req);
            String user = this.userManager.getRemoteUsername(req);
            if (!this.permissionManager.isRequestInApiScope((HttpServletRequest)inputConsumingRequest, clientKey, user)) {
                log.warn("Request not in an authorized API scope from app '{}' as user '{}' on URL '{}'", new Object[]{clientKey, user, req.getRequestURI()});
                res.sendError(403, "Request not in an authorized API scope");
                return;
            }
            log.info("Authorized app '{}' to access API at URL '{}' for user '{}'", new Object[]{clientKey, req.getRequestURI(), user});
            chain.doFilter((ServletRequest)inputConsumingRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public static String extractClientKey(HttpServletRequest req) {
        return (String)req.getAttribute(PLUGIN_KEY);
    }

    public void destroy() {
    }
}

