/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.descriptor;

import com.atlassian.plugin.remotable.descriptor.DelegatingDescriptorAccessor;
import com.atlassian.plugin.remotable.descriptor.DescriptorAccessor;
import com.atlassian.plugin.remotable.descriptor.DescriptorUtils;
import com.atlassian.plugin.remotable.descriptor.LocalMountBaseUrlResolver;
import com.google.common.base.Preconditions;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevModeTransformingDescriptorAccessor
extends DelegatingDescriptorAccessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DescriptorAccessor delegate;
    private final LocalMountBaseUrlResolver baseUrlResolver;
    private final RuntimeContext runtimeContext;

    public DevModeTransformingDescriptorAccessor(DescriptorAccessor delegate, LocalMountBaseUrlResolver baseUrlResolver) {
        this(delegate, baseUrlResolver, new SystemRuntimeContext());
    }

    public DevModeTransformingDescriptorAccessor(DescriptorAccessor delegate, LocalMountBaseUrlResolver baseUrlResolver, RuntimeContext runtimeContext) {
        this.delegate = (DescriptorAccessor)Preconditions.checkNotNull((Object)delegate);
        this.baseUrlResolver = (LocalMountBaseUrlResolver)Preconditions.checkNotNull((Object)baseUrlResolver);
        this.runtimeContext = (RuntimeContext)Preconditions.checkNotNull((Object)runtimeContext);
    }

    private Document transform(Document descriptor) {
        String displayUrl = DescriptorUtils.getDisplayUrl(descriptor);
        if (this.runtimeContext.isDevMode()) {
            String devDisplayUrl = this.baseUrlResolver.getLocalMountBaseUrl(this.getKey());
            this.logger.debug("Replacing set display URL '{}' with new dev URL '{}'", (Object)displayUrl, (Object)devDisplayUrl);
            return DescriptorUtils.addRegistrationWebHook(DescriptorUtils.addDisplayUrl(DescriptorUtils.getRemotePluginContainerElement(descriptor.getRootElement()), devDisplayUrl).getRootElement());
        }
        return DescriptorUtils.addRegistrationWebHook(descriptor.getRootElement());
    }

    @Override
    public Document getDescriptor() {
        return this.transform(this.delegate.getDescriptor());
    }

    @Override
    protected DescriptorAccessor getDelegate() {
        return this.delegate;
    }

    private static final class SystemRuntimeContext
    implements RuntimeContext {
        private SystemRuntimeContext() {
        }

        @Override
        public boolean isDevMode() {
            return Boolean.valueOf(System.getProperty("atlassian.dev.mode", Boolean.toString(Boolean.FALSE))) != false || Boolean.valueOf(System.getProperty("atlassian.ub.container.dev.mode", Boolean.toString(Boolean.FALSE))) != false;
        }
    }

    static interface RuntimeContext {
        public boolean isDevMode();
    }
}

