/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.rest;

import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidator;
import com.atlassian.plugin.remotable.plugin.settings.SettingsManager;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.RemotablePluginInstallationService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.bouncycastle.openssl.PEMWriter;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/installer")
public class InstallerResource {
    private static final Logger log = LoggerFactory.getLogger(InstallerResource.class);
    private final RemotablePluginInstallationService remotablePluginInstallationService;
    private final UserManager userManager;
    private final DescriptorValidator descriptorValidator;
    private final SettingsManager settingsManager;

    public InstallerResource(UserManager userManager, DescriptorValidator descriptorValidator, SettingsManager settingsManager, RemotablePluginInstallationService remotablePluginInstallationService) {
        this.remotablePluginInstallationService = remotablePluginInstallationService;
        this.userManager = userManager;
        this.descriptorValidator = descriptorValidator;
        this.settingsManager = settingsManager;
    }

    @PUT
    @Path(value="/allow-dogfooding")
    public Response allowDogfooding() {
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.settingsManager.setAllowDogfooding(true);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/allow-dogfooding")
    public Response disallowDogfooding() {
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.settingsManager.setAllowDogfooding(false);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/allow-dogfooding")
    public Response doesAllowDogfooding() {
        if (this.settingsManager.isAllowDogfooding()) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response install(@FormParam(value="url") String registrationUrl) {
        try {
            this.remotablePluginInstallationService.install(this.userManager.getRemoteUsername(), registrationUrl);
        }
        catch (PermissionDeniedException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ex.getMessage()).build();
        }
        catch (InstallationFailedException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{pluginKey}")
    public Response installFromMarketplace(@PathParam(value="pluginKey") String pluginKey) {
        try {
            this.remotablePluginInstallationService.installFromMarketplace(this.userManager.getRemoteUsername(), pluginKey);
        }
        catch (PermissionDeniedException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ex.getMessage()).build();
        }
        catch (InstallationFailedException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/reinstall")
    @Produces(value={"text/plain"})
    public Response reinstall() {
        Set keys = null;
        try {
            keys = this.remotablePluginInstallationService.reinstallRemotePlugins(this.userManager.getRemoteUsername());
        }
        catch (PermissionDeniedException ex) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ex.getMessage()).build();
        }
        catch (InstallationFailedException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        return Response.ok().entity((Object)keys.toString()).build();
    }

    @GET
    @Path(value="/schema/atlassian-plugin")
    @Produces(value={"text/xml"})
    @AnonymousAllowed
    public Response getPluginSchema() {
        return Response.ok().entity((Object)this.descriptorValidator.getPluginSchema()).build();
    }

    @POST
    @Path(value="/keygen")
    @Produces(value={"application/json"})
    public Response generateKeys() throws NoSuchAlgorithmException, IOException, JSONException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = gen.generateKeyPair();
        StringWriter publicKeyWriter = new StringWriter();
        PEMWriter pubWriter = new PEMWriter((Writer)publicKeyWriter);
        pubWriter.writeObject((Object)pair.getPublic());
        pubWriter.close();
        StringWriter privateKeyWriter = new StringWriter();
        PEMWriter privWriter = new PEMWriter((Writer)privateKeyWriter);
        privWriter.writeObject((Object)pair.getPrivate());
        privWriter.close();
        return Response.ok((Object)new JSONObject().put("publicKey", (Object)publicKeyWriter.toString()).put("privateKey", (Object)privateKeyWriter.toString()).toString(2)).build();
    }
}

